/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.jupiter.osgi.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ReflectionHelper {
    public static Map<TypeVariable<?>, Type> determineTypeArguments(@NotNull Class<?> clazz) {
        HashMap typeVariableTypeMap = new HashMap();
        ReflectionHelper.determineTypeArguments(clazz, typeVariableTypeMap);
        return Collections.unmodifiableMap(typeVariableTypeMap);
    }

    private static void determineTypeArguments(Class<?> clazz, Map<TypeVariable<?>, Type> typeVariableTypeMap) {
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
            typeVariableTypeMap.putAll(TypeUtils.determineTypeArguments(clazz, (ParameterizedType)parameterizedType));
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                throw new UnsupportedOperationException("Expected Class#getGenericSuperclass() to return an object of type Class<?>");
            }
            ReflectionHelper.determineTypeArguments((Class)rawType, typeVariableTypeMap);
        } else if (genericSuperclass instanceof Class) {
            ReflectionHelper.determineTypeArguments((Class)genericSuperclass, typeVariableTypeMap);
        } else if (genericSuperclass == null) {
            Type[] genericInterfaces;
            for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
                if (!(genericInterface instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
                typeVariableTypeMap.putAll(TypeUtils.determineTypeArguments(clazz, (ParameterizedType)parameterizedType));
            }
        } else {
            throw new UnsupportedOperationException("Expected Class#getGenericSuperclass() to return null or an object of type Class<?> or ParameterizedType");
        }
    }

    @NotNull
    public static ParameterizedType parameterizedTypeForBaseClass(@NotNull Class<?> baseClass, @NotNull Class<?> clazz) {
        ParameterizedType parameterizedType = ReflectionHelper.findParameterizedTypeForBaseClass(baseClass, clazz);
        return Objects.requireNonNull(parameterizedType, () -> String.format("Failed to discover type supported by %s; may be caused by lacking parameterized type in class declaration.", clazz.getName()));
    }

    private static ParameterizedType findParameterizedTypeForBaseClass(Class<?> baseClass, Class<?> clazz) {
        Type rawType;
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null || superclass == Object.class) {
            return null;
        }
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && (rawType = ((ParameterizedType)genericSuperclass).getRawType()) == baseClass) {
            return (ParameterizedType)genericSuperclass;
        }
        return ReflectionHelper.findParameterizedTypeForBaseClass(baseClass, superclass);
    }

    private ReflectionHelper() {
    }
}

