/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.Privilege;
import javax.servlet.Servlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jackrabbit.usermanager.ChangeUserPassword;
import org.apache.sling.jackrabbit.usermanager.impl.post.AbstractAuthorizablePostServlet;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, ChangeUserPassword.class}, property={"sling.servlet.resourceTypes=sling/user", "sling.servlet.methods=POST", "sling.servlet.selectors=changePassword", "sling.servlet.prefix:Integer=-1", "servlet.post.dateFormats=EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss.SSSZ", "servlet.post.dateFormats=yyyy-MM-dd'T'HH:mm:ss", "servlet.post.dateFormats=yyyy-MM-dd", "servlet.post.dateFormats=dd.MM.yyyy HH:mm:ss", "servlet.post.dateFormats=dd.MM.yyyy"})
@Designate(ocd=Config.class)
public class ChangeUserPasswordServlet
extends AbstractAuthorizablePostServlet
implements ChangeUserPassword {
    private static final long serialVersionUID = 1923614318474654502L;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    static final String DEFAULT_USER_ADMIN_GROUP_NAME = "UserAdmin";
    static final String PAR_USER_ADMIN_GROUP_NAME = "user.admin.group.name";
    private String userAdminGroupName = "UserAdmin";
    private boolean alwaysAllowSelfChangePassword = true;
    @Reference
    private transient SlingRepository repository;
    @Reference
    private transient ServiceUserMapped serviceUserMapped;

    @Override
    @Activate
    protected void activate(Map<String, Object> props) {
        super.activate(props);
        this.alwaysAllowSelfChangePassword = OsgiUtil.toBoolean((Object)props.get("alwaysAllowSelfChangePassword"), (boolean)false);
        this.userAdminGroupName = OsgiUtil.toString((Object)props.get(PAR_USER_ADMIN_GROUP_NAME), (String)DEFAULT_USER_ADMIN_GROUP_NAME);
        this.log.debug("User Admin Group Name {}", (Object)this.userAdminGroupName);
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    @Override
    @Reference
    protected void bindSystemUserManagerPaths(SystemUserManagerPaths sump) {
        super.bindSystemUserManagerPaths(sump);
    }

    @Override
    @Reference(service=PostResponseCreator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.bindPostResponseCreator(creator, properties);
    }

    @Override
    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        super.unbindPostResponseCreator(creator, properties);
    }

    @Override
    protected void handleOperation(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        Resource resource = request.getResource();
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        this.changePassword(session, resource.getName(), request.getParameter("oldPwd"), request.getParameter("newPwd"), request.getParameter("newPwdConfirm"), changes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public User changePassword(Session jcrSession, String name, String oldPassword, String newPassword, String newPasswordConfirm, List<Modification> changes) throws RepositoryException {
        if ("anonymous".equals(name)) {
            throw new RepositoryException("Can not change the password of the anonymous user.");
        }
        userManager = AccessControlUtil.getUserManager((Session)jcrSession);
        authorizable = userManager.getAuthorizable(name);
        if (!(authorizable instanceof User)) {
            throw new ResourceNotFoundException("User to update could not be determined");
        }
        user = (User)authorizable;
        administrator = false;
        if (oldPassword == null || oldPassword.length() == 0) {
            try {
                um = AccessControlUtil.getUserManager((Session)jcrSession);
                currentUser = (User)um.getAuthorizable(jcrSession.getUserID());
                administrator = currentUser.isAdmin();
                if (!administrator && (userAdmin = um.getAuthorizable(this.userAdminGroupName)) instanceof Group && (isMember = ((Group)userAdmin).isMember((Authorizable)currentUser))) {
                    administrator = true;
                }
            }
            catch (Exception ex) {
                this.log.warn("Failed to determine if the user is an admin, assuming not. Cause: {}", (Object)ex.getMessage());
                administrator = false;
            }
            if (!administrator) {
                throw new RepositoryException("Old Password was not submitted");
            }
        }
        if (newPassword == null || newPassword.length() == 0) {
            throw new RepositoryException("New Password was not submitted");
        }
        if (!newPassword.equals(newPasswordConfirm)) {
            throw new RepositoryException("New Password does not match the confirmation password");
        }
        if (oldPassword != null && oldPassword.length() > 0) {
            if (this.alwaysAllowSelfChangePassword && jcrSession.getUserID().equals(name)) {
                acm = jcrSession.getAccessControlManager();
                hasRights = acm.hasPrivileges(authorizable.getPath(), new Privilege[]{acm.privilegeFromName("rep:userManagement")});
                if (hasRights) {
                    user.changePassword(newPassword, oldPassword);
                } else {
                    svcSession = null;
                    try {
                        svcSession = this.repository.loginService(null, null);
                        um = AccessControlUtil.getUserManager((Session)svcSession);
                        user2 = (User)um.getAuthorizable(name);
                        user2.changePassword(newPassword, oldPassword);
                        if (!svcSession.hasPendingChanges()) ** GOTO lbl49
                        svcSession.save();
                    }
                    finally {
                        if (svcSession != null) {
                            svcSession.logout();
                        }
                    }
                }
            } else {
                user.changePassword(newPassword, oldPassword);
            }
        } else {
            user.changePassword(newPassword);
        }
lbl49:
        // 5 sources

        passwordPath = this.systemUserManagerPaths.getUserPrefix() + user.getID() + "/rep:password";
        changes.add(Modification.onModified((String)passwordPath));
        return user;
    }

    @ObjectClassDefinition(name="Apache Sling Change User Password")
    public static @interface Config {
        @AttributeDefinition(name="User Admin Group Name", description="Specifies the name of the group whose members are allowed to reset the password of another user.")
        public String user_admin_group_name() default "UserAdmin";

        @AttributeDefinition(name="Allow Self Password Change", description="Specifies whether a user is allowed to change their own password.")
        public boolean allowSelfChangePassword() default true;
    }
}

