/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.sling.jcr.base.util.AccessControlUtil;

public abstract class PrivilegesHelper {
    public static Map<Privilege, Set<Privilege>> buildPrivilegeToAncestorMap(Session jcrSession, String resourcePath) throws RepositoryException {
        Privilege[] supportedPrivileges;
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)jcrSession);
        HashMap<Privilege, Set<Privilege>> privilegeToAncestorMap = new HashMap<Privilege, Set<Privilege>>();
        for (Privilege privilege : supportedPrivileges = accessControlManager.getSupportedPrivileges(resourcePath)) {
            Privilege[] ap;
            if (!privilege.isAggregate()) continue;
            for (Privilege privilege2 : ap = privilege.getAggregatePrivileges()) {
                Set set = privilegeToAncestorMap.computeIfAbsent(privilege2, k -> new HashSet());
                set.add(privilege);
            }
        }
        return privilegeToAncestorMap;
    }

    public static void mergePrivilegeSets(Privilege privilege, Map<Privilege, Set<Privilege>> privilegeToAncestorMap, Set<Privilege> add, Set<Privilege> remove) {
        Set<Privilege> filterSet;
        if (privilege.isAggregate()) {
            Privilege[] aggregatePrivileges = privilege.getAggregatePrivileges();
            List<Privilege> asList = Arrays.asList(aggregatePrivileges);
            add.removeAll(asList);
            for (Privilege removeCandidate : remove) {
                if (!removeCandidate.isAggregate() || !PrivilegesHelper.containsAny(removeCandidate.getAggregatePrivileges(), aggregatePrivileges)) continue;
                remove.remove(removeCandidate);
                remove.addAll(Arrays.asList(removeCandidate.getAggregatePrivileges()));
                remove.removeAll(Arrays.asList(aggregatePrivileges));
            }
            remove.removeAll(asList);
        }
        remove.remove(privilege);
        boolean isAlreadyGranted = false;
        Set<Privilege> ancestorSet = privilegeToAncestorMap.get(privilege);
        if (ancestorSet != null) {
            for (Privilege privilege2 : ancestorSet) {
                if (!add.contains(privilege2)) continue;
                isAlreadyGranted = true;
                break;
            }
        }
        if (!isAlreadyGranted) {
            add.add(privilege);
        }
        if ((filterSet = privilegeToAncestorMap.get(privilege)) != null) {
            for (Privilege privilege2 : filterSet) {
                if (!remove.contains(privilege2)) continue;
                remove.remove(privilege2);
                if (!privilege2.isAggregate()) continue;
                PrivilegesHelper.filterAndMergePrivilegesFromAggregate(privilege2, add, remove, filterSet, privilege);
            }
        }
    }

    private static boolean containsAny(Privilege[] aggregatePrivileges, Privilege[] aggregatePrivileges2) {
        List<Privilege> privs = Arrays.asList(aggregatePrivileges);
        for (Privilege agg2 : aggregatePrivileges2) {
            if (!privs.contains(agg2)) continue;
            return true;
        }
        return false;
    }

    private static void filterAndMergePrivilegesFromAggregate(Privilege privilege, Set<Privilege> firstSet, Set<Privilege> secondSet, Set<Privilege> filterSet, Privilege ignorePrivilege) {
        Privilege[] declaredAggregatePrivileges;
        for (Privilege privilege3 : declaredAggregatePrivileges = privilege.getDeclaredAggregatePrivileges()) {
            Privilege[] declaredAggregatePrivileges2;
            if (ignorePrivilege.equals(privilege3)) continue;
            if (!firstSet.contains(privilege3) && !filterSet.contains(privilege3)) {
                secondSet.add(privilege3);
            }
            if (!privilege3.isAggregate()) continue;
            for (Privilege privilege2 : declaredAggregatePrivileges2 = privilege3.getDeclaredAggregatePrivileges()) {
                if (ignorePrivilege.equals(privilege2) || !privilege2.isAggregate()) continue;
                PrivilegesHelper.filterAndMergePrivilegesFromAggregate(privilege2, firstSet, secondSet, filterSet, ignorePrivilege);
            }
        }
    }

    private PrivilegesHelper() {
    }
}

