/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.sling.jcr.base.util.AccessControlUtil;

public class PrivilegesInfo {
    public Privilege[] getSupportedPrivileges(Node node) throws RepositoryException {
        return this.getSupportedPrivileges(node.getSession(), node.getPath());
    }

    public Privilege[] getSupportedPrivileges(Session session, String absPath) throws RepositoryException {
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
        return accessControlManager.getSupportedPrivileges(absPath);
    }

    public Map<Principal, AccessRights> getDeclaredAccessRights(Node node) throws RepositoryException {
        return this.getDeclaredAccessRights(node.getSession(), node.getPath());
    }

    public Map<Principal, AccessRights> getDeclaredAccessRights(Session session, String absPath) throws RepositoryException {
        AccessControlEntry[] entries = this.getDeclaredAccessControlEntries(session, absPath);
        return this.mergePrivilegesFromEntries(entries);
    }

    private AccessControlEntry[] getDeclaredAccessControlEntries(Session session, String absPath) throws RepositoryException {
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
        AccessControlPolicy[] policies = accessControlManager.getPolicies(absPath);
        ArrayList<AccessControlEntry> allEntries = new ArrayList<AccessControlEntry>();
        for (AccessControlPolicy accessControlPolicy : policies) {
            if (!(accessControlPolicy instanceof AccessControlList)) continue;
            AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
            allEntries.addAll(Arrays.asList(accessControlEntries));
        }
        return allEntries.toArray(new AccessControlEntry[allEntries.size()]);
    }

    public AccessRights getDeclaredAccessRightsForPrincipal(Node node, String principalId) throws RepositoryException {
        return this.getDeclaredAccessRightsForPrincipal(node.getSession(), node.getPath(), principalId);
    }

    public AccessRights getDeclaredAccessRightsForPrincipal(Session session, String absPath, String principalId) throws RepositoryException {
        AccessRights rights = null;
        if (principalId != null && principalId.length() > 0) {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            AccessControlPolicy[] policies = accessControlManager.getPolicies(absPath);
            rights = this.toAccessRights(principalId, policies);
        }
        return rights;
    }

    private AccessRights toAccessRights(String principalId, AccessControlPolicy[] policies) throws RepositoryException {
        AccessRights rights = new AccessRights();
        for (AccessControlPolicy accessControlPolicy : policies) {
            AccessControlEntry[] accessControlEntries;
            if (!(accessControlPolicy instanceof AccessControlList)) continue;
            for (AccessControlEntry ace : accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries()) {
                if (!principalId.equals(ace.getPrincipal().getName())) continue;
                boolean isAllow = AccessControlUtil.isAllow((AccessControlEntry)ace);
                if (isAllow) {
                    rights.getGranted().addAll(Arrays.asList(ace.getPrivileges()));
                    continue;
                }
                rights.getDenied().addAll(Arrays.asList(ace.getPrivileges()));
            }
        }
        return rights;
    }

    public Map<String, Object> getDeclaredRestrictionsForPrincipal(Node node, String principalId) throws RepositoryException {
        return this.getDeclaredRestrictionsForPrincipal(node.getSession(), node.getPath(), principalId);
    }

    public Map<String, Object> getDeclaredRestrictionsForPrincipal(Session session, String absPath, String principalId) throws RepositoryException {
        LinkedHashMap<String, Object> restrictions = new LinkedHashMap<String, Object>();
        AccessControlEntry[] entries = this.getDeclaredAccessControlEntries(session, absPath);
        if (entries != null) {
            for (AccessControlEntry ace : entries) {
                JackrabbitAccessControlEntry jace;
                String[] restrictionNames;
                if (!principalId.equals(ace.getPrincipal().getName()) || !(ace instanceof JackrabbitAccessControlEntry) || (restrictionNames = (jace = (JackrabbitAccessControlEntry)ace).getRestrictionNames()) == null) continue;
                for (String name : restrictionNames) {
                    try {
                        Value value = jace.getRestriction(name);
                        if (value == null) continue;
                        restrictions.put(name, value);
                    }
                    catch (ValueFormatException vfe) {
                        Value[] values = jace.getRestrictions(name);
                        if (values == null || values.length <= 0) continue;
                        restrictions.put(name, values);
                    }
                }
            }
        }
        return restrictions;
    }

    public Map<Principal, AccessRights> getEffectiveAccessRights(Node node) throws RepositoryException {
        return this.getEffectiveAccessRights(node.getSession(), node.getPath());
    }

    public Map<Principal, AccessRights> getEffectiveAccessRights(Session session, String absPath) throws RepositoryException {
        AccessControlEntry[] entries = this.getEffectiveAccessControlEntries(session, absPath);
        return this.mergePrivilegesFromEntries(entries);
    }

    private Map<Principal, AccessRights> mergePrivilegesFromEntries(AccessControlEntry[] entries) throws RepositoryException {
        LinkedHashMap<Principal, AccessRights> accessMap = new LinkedHashMap<Principal, AccessRights>();
        if (entries != null) {
            for (AccessControlEntry ace : entries) {
                Principal principal = ace.getPrincipal();
                AccessRights accessPrivileges = accessMap.computeIfAbsent(principal, k -> new AccessRights());
                boolean allow = AccessControlUtil.isAllow((AccessControlEntry)ace);
                if (allow) {
                    accessPrivileges.getGranted().addAll(Arrays.asList(ace.getPrivileges()));
                    continue;
                }
                accessPrivileges.getDenied().addAll(Arrays.asList(ace.getPrivileges()));
            }
        }
        return accessMap;
    }

    private AccessControlEntry[] getEffectiveAccessControlEntries(Session session, String absPath) throws RepositoryException {
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
        AccessControlPolicy[] policies = accessControlManager.getEffectivePolicies(absPath);
        ArrayList<AccessControlEntry> allEntries = new ArrayList<AccessControlEntry>();
        for (AccessControlPolicy accessControlPolicy : policies) {
            if (!(accessControlPolicy instanceof AccessControlList)) continue;
            AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
            allEntries.addAll(Arrays.asList(accessControlEntries));
        }
        return allEntries.toArray(new AccessControlEntry[allEntries.size()]);
    }

    public AccessRights getEffectiveAccessRightsForPrincipal(Node node, String principalId) throws RepositoryException {
        return this.getEffectiveAccessRightsForPrincipal(node.getSession(), node.getPath(), principalId);
    }

    public AccessRights getEffectiveAccessRightsForPrincipal(Session session, String absPath, String principalId) throws RepositoryException {
        AccessRights rights = null;
        if (principalId != null && principalId.length() > 0) {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            AccessControlPolicy[] policies = accessControlManager.getEffectivePolicies(absPath);
            rights = this.toAccessRights(principalId, policies);
        }
        return rights;
    }

    public boolean canAddChildren(Node node) {
        try {
            return this.canAddChildren(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canAddChildren(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canDeleteChildren(Node node) {
        try {
            return this.canDeleteChildren(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canDeleteChildren(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canDelete(Node node) {
        try {
            return this.canDelete(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canDelete(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            int lastSlash = absPath.lastIndexOf(47);
            String parentPath = lastSlash == 0 ? "/" : absPath.substring(0, lastSlash);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode")}) && this.canDeleteChildren(session, parentPath);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canModifyProperties(Node node) {
        try {
            return this.canModifyProperties(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canModifyProperties(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canReadAccessControl(Node node) {
        try {
            return this.canReadAccessControl(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canReadAccessControl(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canModifyAccessControl(Node node) {
        try {
            return this.canModifyAccessControl(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canModifyAccessControl(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public static class AccessRights {
        private Set<Privilege> granted = new HashSet<Privilege>();
        private Set<Privilege> denied = new HashSet<Privilege>();
        private ResourceBundle resBundle = null;

        private ResourceBundle getResourceBundle(Locale locale) {
            if (this.resBundle == null || !this.resBundle.getLocale().equals(locale)) {
                this.resBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".PrivilegesResources", locale);
            }
            return this.resBundle;
        }

        public Set<Privilege> getGranted() {
            return this.granted;
        }

        public Set<Privilege> getDenied() {
            return this.denied;
        }

        public String getPrivilegeSetDisplayName(Locale locale) {
            if (this.denied != null && !this.denied.isEmpty()) {
                return this.getResourceBundle(locale).getString("privilegeset.custom");
            }
            if (this.granted.isEmpty()) {
                return this.getResourceBundle(locale).getString("privilegeset.none");
            }
            if (this.granted.size() == 1) {
                Iterator<Privilege> iterator = this.granted.iterator();
                Privilege next = iterator.next();
                if ("jcr:all".equals(next.getName())) {
                    return this.getResourceBundle(locale).getString("privilegeset.all");
                }
                if ("jcr:read".equals(next.getName())) {
                    return this.getResourceBundle(locale).getString("privilegeset.readonly");
                }
            } else if (this.granted.size() == 2) {
                Iterator<Privilege> iterator = this.granted.iterator();
                Privilege next = iterator.next();
                Privilege next2 = iterator.next();
                if ("jcr:read".equals(next.getName()) && "jcr:write".equals(next2.getName()) || "jcr:read".equals(next2.getName()) && "jcr:write".equals(next.getName())) {
                    return this.getResourceBundle(locale).getString("privilegeset.readwrite");
                }
            }
            return this.getResourceBundle(locale).getString("privilegeset.custom");
        }
    }
}

