/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal.readers;

import java.util.Map;
import javax.jcr.RepositoryException;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.sling.jcr.contentloader.ContentCreator;
import org.apache.sling.jcr.contentloader.ContentReader;
import org.apache.sling.jcr.contentloader.internal.readers.JsonReader;
import org.osgi.service.component.annotations.Component;

@Component(service={ContentReader.class}, property={"service.vendor=The Apache Software Foundation", "extensions=ordered-json", "contentTypes=application/json"})
public class OrderedJsonReader
extends JsonReader {
    private static final String PN_ORDEREDCHILDREN = "SLING:ordered";
    private static final String PN_ORDEREDCHILDNAME = "SLING:name";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void writeChildren(JsonObject obj, ContentCreator contentCreator) throws RepositoryException {
        if (!obj.containsKey((Object)PN_ORDEREDCHILDREN)) {
            super.writeChildren(obj, contentCreator);
            return;
        }
        for (Map.Entry entry : obj.entrySet()) {
            String n = (String)entry.getKey();
            if (ignoredNames.contains(n)) continue;
            Object o = entry.getValue();
            if (!this.handleSecurity(n, o, contentCreator)) {
                if (!n.equals(PN_ORDEREDCHILDREN)) continue;
                if (!(o instanceof JsonArray)) throw new JsonException("SLING:ordered value must be a JSON array");
                JsonArray children = (JsonArray)o;
                for (int childIndex = 0; childIndex < children.size(); ++childIndex) {
                    Object oc = children.get(childIndex);
                    if (!(oc instanceof JsonObject)) throw new JsonException("SLING:ordered array must only have JSONObject items");
                    JsonObject child = (JsonObject)oc;
                    String childName = child.getString(PN_ORDEREDCHILDNAME, null);
                    if (childName == null || childName.isEmpty()) throw new JsonException("SLING:ordered children must have a name whose key is SLING:name");
                    JsonObjectBuilder builder = Json.createObjectBuilder();
                    for (Map.Entry e : child.entrySet()) {
                        if (PN_ORDEREDCHILDNAME.equals(e.getKey())) continue;
                        builder.add((String)e.getKey(), (JsonValue)e.getValue());
                    }
                    child = builder.build();
                    this.createNode(childName, child, contentCreator);
                }
                continue;
            }
            this.createProperty(n, o, contentCreator);
        }
    }
}

