/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factory.model.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.io.archive.ArchiveReader;
import org.apache.sling.feature.io.artifacts.ArtifactHandler;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.spi.context.ExtensionHandler;
import org.apache.sling.feature.spi.context.ExtensionHandlerContext;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.factory.model.impl.AbstractFeatureModelTask;
import org.apache.sling.installer.factory.model.impl.InstallContext;
import org.osgi.framework.BundleContext;

public class InstallFeatureModelTask
extends AbstractFeatureModelTask {
    private final InstallContext installContext;
    private final List<ExtensionHandler> extensionHandlers;

    public InstallFeatureModelTask(TaskResourceGroup group, InstallContext installContext, BundleContext bundleContext, List<ExtensionHandler> extensionHandlers) {
        super(group, bundleContext);
        this.installContext = installContext;
        this.extensionHandlers = extensionHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(InstallationContext ctx) {
        try {
            TaskResource resource = this.getResource();
            ctx.log("Installing {}", new Object[]{resource.getEntityId()});
            String featureJson = (String)resource.getAttribute("feature");
            if (featureJson == null) {
                ctx.log("Unable to install feature model resource {} : no model found", new Object[]{resource});
                this.getResourceGroup().setFinishState(ResourceState.IGNORED, null, "No model found");
            } else {
                boolean success = false;
                List<InstallableResource> result = this.transform(featureJson, resource);
                if (result == null) {
                    ctx.log("Unable to install feature model resource {} : unable to create resources", new Object[]{resource});
                    this.getResourceGroup().setFinishState(ResourceState.IGNORED, null, "Unable to create resources");
                } else {
                    if (!result.isEmpty()) {
                        OsgiInstaller installer = this.getService(OsgiInstaller.class);
                        if (installer != null) {
                            installer.registerResources(this.getScheme(resource), result.toArray(new InstallableResource[result.size()]));
                        } else {
                            ctx.log("Unable to install feature model resource {} : unable to get OSGi installer", new Object[]{resource});
                            this.getResourceGroup().setFinishState(ResourceState.IGNORED, null, "Unable to get OSGi installer");
                            return;
                        }
                    }
                    this.getResourceGroup().setFinishState(ResourceState.INSTALLED);
                    success = true;
                }
                if (success) {
                    ctx.log("Installed {}", new Object[]{resource.getEntityId()});
                }
            }
        }
        finally {
            this.cleanup();
        }
    }

    private File getArtifactFile(File baseDir, ArtifactId id) {
        return new File(baseDir, id.toMvnPath().replace('/', File.separatorChar));
    }

    private List<InstallableResource> transform(String featureJson, TaskResource rsrc) {
        Feature feature = null;
        try (StringReader reader = new StringReader(featureJson);){
            feature = FeatureJSONReader.read((Reader)reader, null);
        }
        catch (IOException ioe) {
            this.logger.warn("Unable to read feature model file", (Throwable)ioe);
        }
        if (feature == null) {
            return null;
        }
        ArrayList<InstallableResource> result = new ArrayList<InstallableResource>();
        for (Configuration cfg : feature.getConfigurations()) {
            result.add(new InstallableResource("/".concat(cfg.getPid()).concat(".config"), null, cfg.getConfigurationProperties(), null, "config", null));
        }
        if (this.installContext.storageDirectory != null) {
            final byte[] buffer = new byte[0x10000000];
            try (InputStream is = rsrc.getInputStream();){
                ArchiveReader.read((InputStream)is, (ArchiveReader.ArtifactConsumer)new ArchiveReader.ArtifactConsumer(){

                    public void consume(ArtifactId id, InputStream is) throws IOException {
                        File artifactFile = InstallFeatureModelTask.this.getArtifactFile(((InstallFeatureModelTask)InstallFeatureModelTask.this).installContext.storageDirectory, id);
                        if (!artifactFile.exists()) {
                            artifactFile.getParentFile().mkdirs();
                            try (FileOutputStream os = new FileOutputStream(artifactFile);){
                                int l = 0;
                                while ((l = is.read(buffer)) > 0) {
                                    ((OutputStream)os).write(buffer, 0, l);
                                }
                            }
                        }
                    }
                });
            }
            catch (IOException ioe) {
                this.logger.warn("Unable to extract artifacts from feature model " + feature.getId().toMvnId(), (Throwable)ioe);
                return null;
            }
        }
        ContextImpl context = new ContextImpl(result);
        for (Extension ext : feature.getExtensions()) {
            boolean handlerFound = false;
            for (ExtensionHandler eh : this.extensionHandlers) {
                try {
                    handlerFound |= eh.handle(context, ext, feature);
                }
                catch (Exception e) {
                    this.logger.error("Exception while processing extension {} with handler {}", new Object[]{ext, eh, e});
                }
            }
            if (handlerFound) continue;
            if (ExtensionType.ARTIFACTS == ext.getType()) {
                for (Artifact artifact : ext.getArtifacts()) {
                    this.addArtifact(artifact, result);
                }
                continue;
            }
            this.logger.warn("No extension handler found for mandartory extension " + ext);
        }
        for (Artifact bundle : feature.getBundles()) {
            if (this.addArtifact(bundle, result)) continue;
            return null;
        }
        return result;
    }

    private boolean addArtifact(Artifact artifact, List<InstallableResource> result) {
        ArtifactHandler handler;
        File artifactFile;
        File file = artifactFile = this.installContext.storageDirectory == null ? null : this.getArtifactFile(this.installContext.storageDirectory, artifact.getId());
        if (artifactFile == null || !artifactFile.exists()) {
            try {
                handler = this.installContext.artifactManager.getArtifactHandler(artifact.getId().toMvnUrl());
            }
            catch (IOException ignore) {
                return false;
            }
        }
        try {
            handler = new ArtifactHandler(artifactFile);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (handler == null) {
            return false;
        }
        try {
            URLConnection connection = handler.getLocalURL().openConnection();
            connection.connect();
            InputStream is = connection.getInputStream();
            long lastModified = connection.getLastModified();
            String digest = lastModified == 0L ? null : String.valueOf(lastModified);
            Hashtable<String, Object> dict = new Hashtable<String, Object>();
            if (artifact.getStartOrder() > 0) {
                ((Dictionary)dict).put("bundle.startlevel", artifact.getStartOrder());
            }
            ((Dictionary)dict).put("resource.uri.hint", handler.getLocalURL().toString());
            result.add(new InstallableResource("/".concat(artifact.getId().toMvnName()), is, dict, digest, "file", null));
        }
        catch (IOException ioe) {
            this.logger.warn("Unable to read artifact " + handler.getLocalURL(), (Throwable)ioe);
            return false;
        }
        return true;
    }

    public String getSortKey() {
        return "30-" + this.getResource().getAttribute("featureId");
    }

    private ArtifactProvider getLocalArtifactProvider() {
        return new ArtifactProvider(){

            public URL provide(ArtifactId id) {
                ArtifactHandler handler;
                File artifactFile;
                File file = artifactFile = ((InstallFeatureModelTask)InstallFeatureModelTask.this).installContext.storageDirectory == null ? null : InstallFeatureModelTask.this.getArtifactFile(((InstallFeatureModelTask)InstallFeatureModelTask.this).installContext.storageDirectory, id);
                if (artifactFile == null || !artifactFile.exists()) {
                    try {
                        handler = ((InstallFeatureModelTask)InstallFeatureModelTask.this).installContext.artifactManager.getArtifactHandler(id.toMvnUrl());
                    }
                    catch (IOException ignore) {
                        return null;
                    }
                }
                try {
                    handler = new ArtifactHandler(artifactFile);
                }
                catch (MalformedURLException e) {
                    return null;
                }
                if (handler == null) {
                    return null;
                }
                return handler.getLocalURL();
            }
        };
    }

    private class ContextImpl
    implements ExtensionHandlerContext {
        private final List<InstallableResource> results;

        public ContextImpl(List<InstallableResource> results) {
            this.results = results;
        }

        @Override
        public void addBundle(ArtifactId id, URL file, Integer startLevel) {
        }

        @Override
        public void addInstallableArtifact(ArtifactId id, URL url, Map<String, Object> props) {
            try {
                Hashtable dict = new Hashtable();
                props.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> dict.put((String)e.getKey(), e.getValue()));
                InputStream is = url.openStream();
                this.results.add(new InstallableResource("/".concat(id.toMvnName()), is, dict, null, "file", null));
            }
            catch (IOException e2) {
                InstallFeatureModelTask.this.logger.warn("Unable to read artifact " + id + " from url " + url, (Throwable)e2);
            }
        }

        @Override
        public void addConfiguration(String pid, String factoryPid, Dictionary<String, Object> properties) {
            String cfgPid = pid;
            if (factoryPid != null) {
                cfgPid = factoryPid;
            }
            this.results.add(new InstallableResource("/".concat(cfgPid).concat(".config"), null, properties, null, "config", null));
        }

        @Override
        public ArtifactProvider getArtifactProvider() {
            return InstallFeatureModelTask.this.getLocalArtifactProvider();
        }
    }
}

