/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.util;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceException;
import org.xml.sax.Attributes;
import shaded.org.apache.jackrabbit.spi.Name;
import shaded.org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import shaded.org.apache.jackrabbit.spi.commons.name.NameConstants;
import shaded.org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import shaded.org.apache.jackrabbit.util.ISO9075;
import shaded.org.apache.jackrabbit.vault.util.DocViewProperty;

public class DocViewNode {
    public final String name;
    public final String label;
    public final Map<String, DocViewProperty> props = new HashMap<String, DocViewProperty>();
    public String uuid;
    public final String[] mixins;
    public final String primary;

    public DocViewNode(String name, String label, String uuid, Map<String, DocViewProperty> props, String[] mixins, String primary) {
        this.name = name;
        this.label = label;
        this.uuid = uuid;
        this.mixins = mixins;
        this.primary = primary;
        this.props.putAll(props);
    }

    public DocViewNode(String name, String label, Attributes attributes, NamePathResolver npResolver) throws NamespaceException {
        this.name = name;
        this.label = label;
        String uuid = null;
        String primary = null;
        String[] mixins = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getType(i).equals("CDATA")) continue;
            Name pName = NameFactoryImpl.getInstance().create(attributes.getURI(i), ISO9075.decode(attributes.getLocalName(i)));
            DocViewProperty info = DocViewProperty.parse(npResolver.getJCRName(pName), attributes.getValue(i));
            this.props.put(info.name, info);
            if (pName.equals(NameConstants.JCR_UUID)) {
                uuid = info.values[0];
                continue;
            }
            if (pName.equals(NameConstants.JCR_PRIMARYTYPE)) {
                primary = info.values[0];
                continue;
            }
            if (!pName.equals(NameConstants.JCR_MIXINTYPES)) continue;
            mixins = info.values;
        }
        this.uuid = uuid;
        this.mixins = mixins;
        this.primary = primary;
    }

    public String[] getValues(String name) {
        DocViewProperty prop = this.props.get(name);
        return prop == null ? null : prop.values;
    }

    public String getValue(String name) {
        DocViewProperty prop = this.props.get(name);
        return prop == null ? null : prop.values[0];
    }
}

