/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import shaded.org.apache.commons.io.FileUtils;
import shaded.org.apache.jackrabbit.vault.fs.api.FilterSet;
import shaded.org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import shaded.org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import shaded.org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import shaded.org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import shaded.org.apache.jackrabbit.vault.packaging.Dependency;
import shaded.org.apache.jackrabbit.vault.packaging.PackageId;
import shaded.org.apache.jackrabbit.vault.packaging.SubPackageHandling;
import shaded.org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageStatus;
import shaded.org.apache.jackrabbit.vault.util.RejectingEntityResolver;
import shaded.org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import shaded.org.apache.jackrabbit.vault.util.xml.serialize.XMLSerializer;

public class FSInstallState {
    private static final String TAG_REGISTRY_METADATA = "registryMetadata";
    private static final String ATTR_PACKAGE_ID = "packageid";
    private static final String ATTR_FILE_PATH = "filepath";
    private static final String ATTR_PACKAGE_STATUS = "packagestatus";
    private static final String ATTR_EXTERNAL = "external";
    private static final String ATTR_SIZE = "size";
    private static final String TAG_DEPENDENCY = "dependency";
    private static final String TAG_SUBPACKAGE = "subpackage";
    private static final String ATTR_INSTALLATION_TIME = "installtime";
    private static final String ATTR_SUBPACKAGE_HANDLING_OPTION = "sphoption";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_WORKSPACEFILTER = "workspacefilter";
    private static final String ATTR_ROOT = "root";
    private static final String TAG_RULE = "rule";
    private static final String ATTR_INCLUDE = "include";
    private static final String ATTR_EXCLUDE = "exclude";
    private static final String TAG_PACKAGEPROPERTIES = "packageproperties";
    private final PackageId packageId;
    private final FSPackageStatus status;
    private Path filePath;
    private boolean external;
    private Set<Dependency> dependencies = Collections.emptySet();
    private Map<PackageId, SubPackageHandling.Option> subPackages = Collections.emptyMap();
    private Long installTime;
    private long size = 0L;
    private WorkspaceFilter filter;
    private Properties properties = new Properties();

    public FSInstallState(@Nonnull PackageId pid, @Nonnull FSPackageStatus status) {
        this.packageId = pid;
        this.status = status;
    }

    public FSInstallState withFilePath(Path filePath) {
        this.filePath = filePath;
        return this;
    }

    public FSInstallState withExternal(boolean external) {
        this.external = external;
        return this;
    }

    public FSInstallState withDependencies(Set<Dependency> dependencies) {
        this.dependencies = dependencies == null ? Collections.emptySet() : Collections.unmodifiableSet(dependencies);
        return this;
    }

    public FSInstallState withSubPackages(Map<PackageId, SubPackageHandling.Option> subPackages) {
        this.subPackages = subPackages == null ? Collections.emptyMap() : Collections.unmodifiableMap(subPackages);
        return this;
    }

    public FSInstallState withInstallTime(Long installTime) {
        this.installTime = installTime;
        return this;
    }

    public FSInstallState withSize(long size) {
        this.size = size;
        return this;
    }

    public FSInstallState withFilter(WorkspaceFilter filter) {
        this.filter = filter;
        return this;
    }

    public FSInstallState withProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    @Nullable
    public static FSInstallState fromFile(File metaFile) throws IOException {
        if (!metaFile.exists()) {
            return null;
        }
        try (FileInputStream in = FileUtils.openInputStream(metaFile);){
            FSInstallState fSInstallState = FSInstallState.fromStream(in, metaFile.getPath());
            return fSInstallState;
        }
    }

    @Nullable
    public static FSInstallState fromStream(InputStream in, String systemId) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new RejectingEntityResolver());
            Document document = builder.parse(in, systemId);
            Element doc = document.getDocumentElement();
            if (!TAG_REGISTRY_METADATA.equals(doc.getNodeName())) {
                return null;
            }
            String packageId = doc.getAttribute(ATTR_PACKAGE_ID);
            Path filePath = Paths.get(doc.getAttribute(ATTR_FILE_PATH), new String[0]);
            Long installTime = null;
            if (doc.hasAttribute(ATTR_INSTALLATION_TIME)) {
                installTime = Long.valueOf(doc.getAttribute(ATTR_INSTALLATION_TIME));
            }
            boolean external = Boolean.parseBoolean(doc.getAttribute(ATTR_EXTERNAL));
            long size = 0L;
            if (doc.hasAttribute(ATTR_SIZE)) {
                size = Long.valueOf(doc.getAttribute(ATTR_SIZE));
            }
            FSPackageStatus status = FSPackageStatus.valueOf(doc.getAttribute(ATTR_PACKAGE_STATUS).toUpperCase());
            NodeList nl = doc.getChildNodes();
            HashSet<Dependency> dependencies = new HashSet<Dependency>();
            HashMap<PackageId, SubPackageHandling.Option> subPackages = new HashMap<PackageId, SubPackageHandling.Option>();
            WorkspaceFilter filter = null;
            Properties properties = new Properties();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                String childName = child.getNodeName();
                if (TAG_DEPENDENCY.equals(childName)) {
                    dependencies.add(FSInstallState.readDependency((Element)child));
                    continue;
                }
                if (TAG_SUBPACKAGE.equals(childName)) {
                    subPackages.put(FSInstallState.readPackageId((Element)child), FSInstallState.readSubPackgeHandlingOption((Element)child));
                    continue;
                }
                if (TAG_WORKSPACEFILTER.equals(childName)) {
                    filter = FSInstallState.readWorkspaceFilter((Element)child);
                    continue;
                }
                if (TAG_PACKAGEPROPERTIES.equals(childName)) {
                    properties = FSInstallState.readProperties((Element)child);
                    continue;
                }
                throw new IOException("<dependency> or <subpackage> or <workspacefilter> expected.");
            }
            return new FSInstallState(PackageId.fromString(packageId), status).withFilePath(filePath).withExternal(external).withSize(size).withFilter(filter).withDependencies(dependencies).withSubPackages(subPackages).withProperties(properties).withInstallTime(installTime);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Unable to create configuration XML parser", e);
        }
        catch (SAXException e) {
            throw new IOException("Configuration file syntax error.", e);
        }
    }

    private static Properties readProperties(Element child) {
        Properties properties = new Properties();
        NamedNodeMap attributes = child.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            properties.put(attr.getNodeName(), attr.getNodeValue());
        }
        return properties;
    }

    private static Dependency readDependency(Element child) {
        return Dependency.fromString(child.getAttribute(ATTR_PACKAGE_ID));
    }

    private static SubPackageHandling.Option readSubPackgeHandlingOption(Element child) {
        return SubPackageHandling.Option.valueOf(child.getAttribute(ATTR_SUBPACKAGE_HANDLING_OPTION));
    }

    private static PackageId readPackageId(Element child) {
        return PackageId.fromString(child.getAttribute(ATTR_PACKAGE_ID));
    }

    private static WorkspaceFilter readWorkspaceFilter(Element child) {
        DefaultWorkspaceFilter wsfilter = new DefaultWorkspaceFilter();
        NodeList nl = child.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node filter = nl.item(i);
            if (filter.getNodeType() != 1) continue;
            PathFilterSet pfs = new PathFilterSet(((Element)filter).getAttribute(ATTR_ROOT));
            NodeList nlf = filter.getChildNodes();
            for (int j = 0; j < nlf.getLength(); ++j) {
                DefaultPathFilter pf;
                Node rule = nlf.item(j);
                if (rule.getNodeType() != 1) continue;
                if (((Element)rule).hasAttribute(ATTR_INCLUDE)) {
                    pf = new DefaultPathFilter(((Element)rule).getAttribute(ATTR_INCLUDE));
                    pfs.addInclude(pf);
                    continue;
                }
                if (!((Element)rule).hasAttribute(ATTR_EXCLUDE)) continue;
                pf = new DefaultPathFilter(((Element)rule).getAttribute(ATTR_INCLUDE));
                pfs.addExclude(pf);
            }
            wsfilter.add(pfs);
        }
        return wsfilter;
    }

    public void save(File file) throws IOException {
        try (FileOutputStream out = FileUtils.openOutputStream(file);){
            this.save(out);
        }
    }

    public void save(OutputStream out) throws IOException {
        try {
            XMLSerializer ser = new XMLSerializer(out, new OutputFormat("xml", "UTF-8", true));
            ser.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(null, null, ATTR_PACKAGE_ID, "CDATA", this.packageId.toString());
            attrs.addAttribute(null, null, ATTR_SIZE, "CDATA", Long.toString(this.size));
            if (this.installTime != null) {
                attrs.addAttribute(null, null, ATTR_INSTALLATION_TIME, "CDATA", Long.toString(this.installTime));
            }
            attrs.addAttribute(null, null, ATTR_FILE_PATH, "CDATA", this.filePath.toString());
            attrs.addAttribute(null, null, ATTR_EXTERNAL, "CDATA", Boolean.toString(this.external));
            attrs.addAttribute(null, null, ATTR_PACKAGE_STATUS, "CDATA", this.status.name().toLowerCase());
            ser.startElement(null, null, TAG_REGISTRY_METADATA, attrs);
            if (this.filter != null && !this.filter.getFilterSets().isEmpty()) {
                ser.startElement(null, null, TAG_WORKSPACEFILTER, null);
                for (PathFilterSet pfs : this.filter.getFilterSets()) {
                    attrs = new AttributesImpl();
                    attrs.addAttribute(null, null, ATTR_ROOT, "CDATA", pfs.getRoot());
                    ser.startElement(null, null, TAG_FILTER, attrs);
                    for (FilterSet.Entry pf : pfs.getEntries()) {
                        attrs = new AttributesImpl();
                        DefaultPathFilter dpf = (DefaultPathFilter)pf.getFilter();
                        if (pf.isInclude()) {
                            attrs.addAttribute(null, null, ATTR_INCLUDE, "CDATA", dpf.getPattern());
                        } else {
                            attrs.addAttribute(null, null, ATTR_EXCLUDE, "CDATA", dpf.getPattern());
                        }
                        ser.startElement(null, null, TAG_RULE, attrs);
                        ser.endElement(TAG_RULE);
                    }
                    ser.endElement(TAG_FILTER);
                }
                ser.endElement(TAG_WORKSPACEFILTER);
            }
            if (this.dependencies != null) {
                for (Dependency dependency : this.dependencies) {
                    attrs = new AttributesImpl();
                    attrs.addAttribute(null, null, ATTR_PACKAGE_ID, "CDATA", dependency.toString());
                    ser.startElement(null, null, TAG_DEPENDENCY, attrs);
                    ser.endElement(TAG_DEPENDENCY);
                }
            }
            if (this.subPackages != null) {
                for (PackageId subPackId : this.subPackages.keySet()) {
                    attrs = new AttributesImpl();
                    attrs.addAttribute(null, null, ATTR_PACKAGE_ID, "CDATA", subPackId.toString());
                    attrs.addAttribute(null, null, ATTR_SUBPACKAGE_HANDLING_OPTION, "CDATA", this.subPackages.get(subPackId).toString());
                    ser.startElement(null, null, TAG_SUBPACKAGE, attrs);
                    ser.endElement(TAG_SUBPACKAGE);
                }
            }
            attrs = new AttributesImpl();
            for (String key : this.properties.stringPropertyNames()) {
                attrs.addAttribute(null, null, key, "CDATA", this.properties.getProperty(key));
            }
            if (attrs.getLength() > 0) {
                ser.startElement(null, null, TAG_PACKAGEPROPERTIES, attrs);
                ser.endElement(TAG_PACKAGEPROPERTIES);
            }
            ser.endElement(TAG_REGISTRY_METADATA);
            ser.endDocument();
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public Long getInstallationTime() {
        return this.installTime;
    }

    public Map<PackageId, SubPackageHandling.Option> getSubPackages() {
        return this.subPackages;
    }

    public PackageId getPackageId() {
        return this.packageId;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public boolean isExternal() {
        return this.external;
    }

    public FSPackageStatus getStatus() {
        return this.status;
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public long getSize() {
        return this.size;
    }

    public WorkspaceFilter getFilter() {
        return this.filter;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

