/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.jcr.Session;
import shaded.org.apache.jackrabbit.vault.fs.io.ImportOptions;
import shaded.org.apache.jackrabbit.vault.packaging.Dependency;
import shaded.org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import shaded.org.apache.jackrabbit.vault.packaging.PackageException;
import shaded.org.apache.jackrabbit.vault.packaging.PackageExistsException;
import shaded.org.apache.jackrabbit.vault.packaging.PackageId;
import shaded.org.apache.jackrabbit.vault.packaging.registry.DependencyReport;
import shaded.org.apache.jackrabbit.vault.packaging.registry.ExecutionPlanBuilder;
import shaded.org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import shaded.org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import shaded.org.apache.jackrabbit.vault.packaging.registry.impl.DependencyReportImpl;
import shaded.org.apache.jackrabbit.vault.packaging.registry.impl.ExecutionPlanBuilderImpl;
import shaded.org.apache.jackrabbit.vault.packaging.registry.impl.InternalPackageRegistry;

public abstract class AbstractPackageRegistry
implements PackageRegistry,
InternalPackageRegistry {
    public static final String DEFAULT_PACKAGE_ROOT_PATH = "/etc/packages";
    public static final String ARCHIVE_PACKAGE_ROOT_PATH = "/jcr_root/etc/packages";
    public static final String DEFAULT_PACKAGE_ROOT_PATH_PREFIX = "/etc/packages/";

    @Override
    public abstract void installPackage(Session var1, RegisteredPackage var2, ImportOptions var3, boolean var4) throws IOException, PackageException;

    @Override
    public abstract void uninstallPackage(Session var1, RegisteredPackage var2, ImportOptions var3) throws IOException, PackageException;

    @Override
    public abstract boolean contains(PackageId var1) throws IOException;

    @Override
    public abstract Set<PackageId> packages() throws IOException;

    @Override
    public abstract RegisteredPackage open(PackageId var1) throws IOException;

    @Override
    public abstract PackageId register(InputStream var1, boolean var2) throws IOException, PackageExistsException;

    @Override
    public abstract PackageId register(File var1, boolean var2) throws IOException, PackageExistsException;

    @Override
    public abstract PackageId registerExternal(File var1, boolean var2) throws IOException, PackageExistsException;

    @Override
    public abstract void remove(PackageId var1) throws IOException, NoSuchPackageException;

    @Override
    @Nonnull
    public DependencyReport analyzeDependencies(@Nonnull PackageId id, boolean onlyInstalled) throws IOException, NoSuchPackageException {
        LinkedList<Dependency> unresolved = new LinkedList<Dependency>();
        LinkedList<PackageId> resolved = new LinkedList<PackageId>();
        try (RegisteredPackage pkg = this.open(id);){
            if (pkg == null) {
                throw new NoSuchPackageException().setId(id);
            }
            for (Dependency dep : pkg.getPackage().getDependencies()) {
                PackageId resolvedId = this.resolve(dep, onlyInstalled);
                if (resolvedId == null) {
                    unresolved.add(dep);
                    continue;
                }
                resolved.add(resolvedId);
            }
        }
        return new DependencyReportImpl(id, unresolved.toArray(new Dependency[unresolved.size()]), resolved.toArray(new PackageId[resolved.size()]));
    }

    @Override
    public abstract PackageId resolve(Dependency var1, boolean var2) throws IOException;

    @Override
    @Nonnull
    public PackageId[] usage(PackageId id) throws IOException {
        TreeSet<PackageId> usages = new TreeSet<PackageId>();
        block12: for (PackageId pid : this.packages()) {
            RegisteredPackage pkg = this.open(pid);
            Throwable throwable = null;
            try {
                if (pkg == null || !pkg.isInstalled()) continue;
                for (Dependency dep : pkg.getPackage().getDependencies()) {
                    if (!dep.matches(id)) continue;
                    usages.add(pid);
                    continue block12;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pkg == null) continue;
                if (throwable != null) {
                    try {
                        pkg.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pkg.close();
            }
        }
        return usages.toArray(new PackageId[usages.size()]);
    }

    @Override
    @Nonnull
    public ExecutionPlanBuilder createExecutionPlan() {
        return new ExecutionPlanBuilderImpl(this);
    }

    public String getRelativeInstallationPath(PackageId id) {
        StringBuilder b = new StringBuilder("/");
        if (id.getGroup().length() > 0) {
            b.append(id.getGroup());
            b.append("/");
        }
        b.append(id.getName());
        String v = id.getVersion().toString();
        if (v.length() > 0) {
            b.append("-").append(v);
        }
        return b.toString();
    }

    protected static PackageId createRandomPid() {
        return new PackageId("temporary", "pack_" + UUID.randomUUID().toString(), (String)null);
    }
}

