/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.spi.impl.jcr20;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import shaded.org.apache.jackrabbit.vault.fs.spi.ACLManagement;

public class JcrACLManagement
implements ACLManagement {
    @Override
    public boolean isACLNodeType(String name) {
        return name.equals("rep:ACL") || name.equals("rep:CugPolicy");
    }

    @Override
    public boolean isAccessControllableMixin(String name) {
        return name.equals("rep:AccessControllable") || name.equals("rep:RepoAccessControllable") || name.equals("rep:CugMixin");
    }

    @Override
    public boolean isACLNode(Node node) throws RepositoryException {
        return node.isNodeType("rep:Policy");
    }

    @Override
    public boolean ensureAccessControllable(Node node, String policyPrimaryType) throws RepositoryException {
        boolean modified = false;
        if ("rep:ACL".equals(policyPrimaryType)) {
            if (!node.isNodeType("rep:AccessControllable")) {
                node.addMixin("rep:AccessControllable");
                modified = true;
            }
            if (JcrACLManagement.isRootNode(node) && !node.isNodeType("rep:RepoAccessControllable")) {
                node.addMixin("rep:RepoAccessControllable");
                modified = true;
            }
        } else if ("rep:CugPolicy".equals(policyPrimaryType) && !node.isNodeType("rep:CugMixin")) {
            node.addMixin("rep:CugMixin");
            modified = true;
        }
        return modified;
    }

    @Override
    public void clearACL(Node node) throws RepositoryException {
        AccessControlManager ac = node.getSession().getAccessControlManager();
        String pPath = node.getPath();
        for (AccessControlPolicy p : ac.getPolicies(pPath)) {
            ac.removePolicy(pPath, p);
        }
        if (JcrACLManagement.isRootNode(node)) {
            for (AccessControlPolicy p : ac.getPolicies(null)) {
                ac.removePolicy(null, p);
            }
        }
    }

    private static boolean isRootNode(Node node) throws RepositoryException {
        return node.getDepth() == 0;
    }
}

