/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.impl.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import shaded.org.apache.jackrabbit.spi.Name;
import shaded.org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import shaded.org.apache.jackrabbit.spi.commons.conversion.NameException;
import shaded.org.apache.jackrabbit.spi.commons.conversion.NameParser;
import shaded.org.apache.jackrabbit.spi.commons.name.NameConstants;
import shaded.org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import shaded.org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import shaded.org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import shaded.org.apache.jackrabbit.util.ISO9075;
import shaded.org.apache.jackrabbit.vault.fs.api.Aggregate;
import shaded.org.apache.jackrabbit.vault.fs.impl.io.AggregateWalkListener;
import shaded.org.apache.jackrabbit.vault.util.DocViewProperty;
import shaded.org.apache.jackrabbit.vault.util.ItemNameComparator;
import shaded.org.apache.jackrabbit.vault.util.Text;

public class DocViewSAXFormatter
implements AggregateWalkListener {
    public static final String CDATA_TYPE = "CDATA";
    protected final Session session;
    protected final NamespaceResolver nsResolver;
    protected final ContentHandler contentHandler;
    protected final String jcrPrimaryType;
    protected final String ntUnstructured;
    protected final String jcrMixinTypes;
    protected final String jcrUUID;
    protected final String jcrRoot;
    private final List<Property> props = new ArrayList<Property>();
    private final Aggregate aggregate;
    private final boolean useBinaryReferences;
    private final Set<String> ignored = new HashSet<String>();

    protected DocViewSAXFormatter(Aggregate aggregate, ContentHandler contentHandler) throws RepositoryException {
        this.aggregate = aggregate;
        this.session = aggregate.getNode().getSession();
        this.nsResolver = new SessionNamespaceResolver(this.session);
        this.contentHandler = contentHandler;
        DefaultNamePathResolver npResolver = new DefaultNamePathResolver(this.nsResolver);
        try {
            this.jcrPrimaryType = npResolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
            this.jcrMixinTypes = npResolver.getJCRName(NameConstants.JCR_MIXINTYPES);
            this.jcrUUID = npResolver.getJCRName(NameConstants.JCR_UUID);
            this.jcrRoot = npResolver.getJCRName(NameConstants.JCR_ROOT);
            this.ntUnstructured = npResolver.getJCRName(NameConstants.NT_UNSTRUCTURED);
        }
        catch (NamespaceException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            throw new RepositoryException(msg, e);
        }
        this.useBinaryReferences = "true".equals(aggregate.getManager().getConfig().getProperty("useBinaryReferences"));
    }

    private void startNamespaceDeclarations() throws RepositoryException, SAXException {
        this.contentHandler.startPrefixMapping("jcr", "http://www.jcp.org/jcr/1.0");
        for (String prefix : this.aggregate.getNamespacePrefixes()) {
            if ("xml".equals(prefix) || "jcr".equals(prefix)) continue;
            this.contentHandler.startPrefixMapping(prefix, this.aggregate.getNamespaceURI(prefix));
        }
    }

    private void endNamespaceDeclarations() throws RepositoryException, SAXException {
        this.contentHandler.endPrefixMapping("jcr");
        for (String prefix : this.aggregate.getNamespacePrefixes()) {
            if ("xml".equals(prefix) || "jcr".equals(prefix)) continue;
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    private Name getQName(String rawName) throws RepositoryException {
        try {
            return NameParser.parse(rawName, this.nsResolver, NameFactoryImpl.getInstance());
        }
        catch (NameException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            throw new RepositoryException(msg, e);
        }
    }

    @Override
    public void onWalkBegin(Node root) throws RepositoryException {
        this.ignored.clear();
        this.ignored.add("jcr:created");
        this.ignored.add("jcr:createdBy");
        this.ignored.add("jcr:baseVersion");
        this.ignored.add("jcr:versionHistory");
        this.ignored.add("jcr:predecessors");
        try {
            this.contentHandler.startDocument();
            this.startNamespaceDeclarations();
        }
        catch (SAXException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void onWalkEnd(Node root) throws RepositoryException {
        try {
            this.endNamespaceDeclarations();
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void onNodeBegin(Node node, boolean included, int level) throws RepositoryException {
        this.aggregate.getManager().addNodeTypes(node);
        this.props.clear();
    }

    @Override
    public void onChildren(Node node, int level) throws RepositoryException {
        String label = Text.getName(node.getPath());
        String elemName = level == 0 || node.getDepth() == 0 ? this.jcrRoot : ISO9075.encode(label);
        AttributesImpl attrs = new AttributesImpl();
        Collections.sort(this.props, ItemNameComparator.INSTANCE);
        for (Property prop : this.props) {
            String attrName = ISO9075.encode(prop.getName());
            Name qName = this.getQName(attrName);
            boolean sort = qName.equals(NameConstants.JCR_MIXINTYPES);
            attrs.addAttribute(qName.getNamespaceURI(), qName.getLocalName(), attrName, CDATA_TYPE, DocViewProperty.format(prop, sort, this.useBinaryReferences));
        }
        Name qName = this.getQName(elemName);
        try {
            this.contentHandler.startElement(qName.getNamespaceURI(), qName.getLocalName(), elemName, attrs);
        }
        catch (SAXException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void onNodeEnd(Node node, boolean included, int level) throws RepositoryException {
        String label = Text.getName(node.getPath());
        String elemName = node.getDepth() == 0 ? this.jcrRoot : ISO9075.encode(label);
        Name qName = this.getQName(elemName);
        try {
            this.contentHandler.endElement(qName.getNamespaceURI(), qName.getLocalName(), elemName);
        }
        catch (SAXException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void onProperty(Property prop, int level) throws RepositoryException {
        if (this.ignored.contains(prop.getName()) && prop.getDefinition().isProtected()) {
            return;
        }
        this.props.add(prop);
    }

    @Override
    public void onNodeIgnored(Node node, int depth) throws RepositoryException {
        String label = Text.getName(node.getPath());
        String elemName = ISO9075.encode(label);
        Name qName = this.getQName(elemName);
        try {
            this.contentHandler.startElement(qName.getNamespaceURI(), qName.getLocalName(), elemName, null);
            this.contentHandler.endElement(qName.getNamespaceURI(), qName.getLocalName(), elemName);
        }
        catch (SAXException e) {
            throw new RepositoryException(e);
        }
    }
}

