/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.impl.io;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.jackrabbit.vault.fs.api.ImportInfo;

public class ChildNodeStash {
    static final Logger log = LoggerFactory.getLogger(ChildNodeStash.class);
    private final Session session;
    private Node tmpNode;
    private final Set<String> excludedNodeName = new HashSet<String>();
    private static final String[] ROOTS = new String[]{"/", "/tmp", "/var", "/etc", "/content"};

    public ChildNodeStash(Session session) {
        this.session = session;
    }

    private Node getOrCreateTemporaryNode() throws RepositoryException {
        if (this.tmpNode != null) {
            return this.tmpNode;
        }
        for (String rootPath : ROOTS) {
            try {
                Node root = this.session.getNode(rootPath);
                this.tmpNode = root.addNode("tmp" + System.currentTimeMillis(), "nt:unstructured");
                return this.tmpNode;
            }
            catch (RepositoryException e) {
                log.debug("unable to create temporary stash location below {}.", (Object)rootPath);
            }
        }
        throw new RepositoryException("Unable to create temporary root below.");
    }

    public ChildNodeStash excludeName(String name) {
        this.excludedNodeName.add(name);
        return this;
    }

    public void stashChildren(String parentPath) throws RepositoryException {
        this.stashChildren(this.session.getNode(parentPath));
    }

    public void stashChildren(Node parent) {
        try {
            NodeIterator iter = parent.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                String name = child.getName();
                if (this.excludedNodeName.contains(name)) {
                    log.debug("skipping excluded child node from stash: {}", (Object)child.getPath());
                    continue;
                }
                Node tmp = this.getOrCreateTemporaryNode();
                try {
                    this.session.move(child.getPath(), tmp.getPath() + "/" + name);
                }
                catch (RepositoryException e) {
                    log.error("Error while moving child node to temporary location. Child will be removed.", (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("error while moving child nodes (ignored)", (Throwable)e);
        }
    }

    public void recoverChildren(String parentPath) throws RepositoryException {
        this.recoverChildren(this.session.getNode(parentPath), null);
    }

    public void recoverChildren(Node parent, ImportInfo importInfo) throws RepositoryException {
        if (this.tmpNode != null) {
            NodeIterator iter = this.tmpNode.getNodes();
            boolean hasErrors = false;
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                String newPath = parent.getPath() + "/" + child.getName();
                try {
                    if (this.session.nodeExists(newPath)) {
                        log.debug("Skipping restore from temporary location {} as node already exists at {}", (Object)child.getPath(), (Object)newPath);
                        continue;
                    }
                    this.session.move(child.getPath(), newPath);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to move child back to new location at {} due to: {}. Node will remain in temporary location: {}", new Object[]{newPath, e.getMessage(), child.getPath()});
                    if (importInfo == null) continue;
                    importInfo.onError(newPath, e);
                    hasErrors = true;
                }
            }
            if (!hasErrors) {
                this.tmpNode.remove();
            }
        }
    }
}

