/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.api;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import shaded.org.apache.jackrabbit.vault.fs.api.PathMapping;
import shaded.org.apache.jackrabbit.vault.util.Text;

public class MultiPathMapping
implements PathMapping {
    private final Map<String, String> links = new HashMap<String, String>();
    private final Map<String, String> reverseLinks = new HashMap<String, String>();

    public MultiPathMapping link(@Nonnull String src, @Nonnull String dst) {
        this.links.put(src, dst);
        this.reverseLinks.put(dst, src);
        return this;
    }

    @Nonnull
    public MultiPathMapping merge(@Nullable MultiPathMapping base) {
        if (base != null) {
            this.links.putAll(base.links);
            this.reverseLinks.putAll(base.reverseLinks);
        }
        return this;
    }

    @Override
    @Nonnull
    public String map(@Nonnull String path) {
        return this.map(path, false);
    }

    @Override
    @Nonnull
    public String map(@Nonnull String path, boolean reverse) {
        if (path.length() == 0 || "/".equals(path)) {
            return path;
        }
        Map<String, String> lookup = reverse ? this.reverseLinks : this.links;
        String[] segs = Text.explode(path, 47);
        String ret = "";
        for (String name : segs) {
            String link = lookup.get(ret = ret + "/" + name);
            if (link == null) continue;
            ret = link;
        }
        return ret;
    }
}

