/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.MemoryArchive;
import org.apache.jackrabbit.vault.fs.io.ZipArchive;
import org.apache.jackrabbit.vault.fs.spi.NodeTypeSet;
import org.apache.jackrabbit.vault.packaging.CyclicDependencyException;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.DependencyException;
import org.apache.jackrabbit.vault.packaging.DependencyHandling;
import org.apache.jackrabbit.vault.packaging.DependencyUtil;
import org.apache.jackrabbit.vault.packaging.ExportOptions;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.SubPackageHandling;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.Version;
import org.apache.jackrabbit.vault.packaging.events.PackageEvent;
import org.apache.jackrabbit.vault.packaging.impl.InstallContextImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageDefinitionImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.impl.ZipVaultPackage;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.JcrPackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.impl.JcrRegisteredPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPackageImpl
implements JcrPackage {
    public static final long MAX_MEMORY_ARCHIVE_SIZE = 0x100000L;
    private static final Logger log = LoggerFactory.getLogger(JcrPackageImpl.class);
    private final JcrPackageRegistry mgr;
    @Nullable
    private Node node;
    @Nullable
    private ZipVaultPackage pack;
    @Nullable
    private JcrPackageDefinitionImpl def;

    public JcrPackageImpl(@NotNull JcrPackageRegistry mgr, @Nullable Node node) throws RepositoryException {
        this.mgr = mgr;
        this.node = node;
    }

    public JcrPackageImpl(@NotNull JcrPackageRegistry mgr, @Nullable Node node, @Nullable ZipVaultPackage pack) throws RepositoryException {
        this.mgr = mgr;
        this.node = node;
        this.pack = pack;
    }

    @Override
    public JcrPackageDefinition getDefinition() throws RepositoryException {
        if (this.def == null && this.isValid()) {
            Node defNode = this.getDefNode();
            this.def = defNode == null ? null : new JcrPackageDefinitionImpl(defNode);
        }
        return this.def;
    }

    @Override
    public int compareTo(JcrPackage o) {
        try {
            JcrPackageDefinition d1 = this.getDefinition();
            JcrPackageDefinition d2 = o.getDefinition();
            return d1.getId().compareTo(d2.getId());
        }
        catch (Exception e) {
            log.error("error during compare: {}", (Object)e.toString());
            return 0;
        }
    }

    @Override
    public boolean isValid() {
        try {
            if (this.node != null && this.node.isNodeType("nt:hierarchyNode") && this.node.hasNode("jcr:content") && this.node.getNode("jcr:content").isNodeType("vlt:Package")) {
                return true;
            }
        }
        catch (RepositoryException e) {
            log.warn("Error during evaluation of isValid()", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean isInstalled() throws RepositoryException {
        JcrPackageDefinition def = this.getDefinition();
        return def != null && def.getLastUnpacked() != null;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() <= 0L;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public boolean isSealed() {
        try {
            if (!this.isValid()) {
                return false;
            }
            if (this.getSize() == 0L) {
                return false;
            }
            JcrPackageDefinition def = this.getDefinition();
            return def == null || !def.isModified();
        }
        catch (RepositoryException e) {
            log.warn("Error during isSealed()", (Throwable)e);
            return false;
        }
    }

    @Override
    @Deprecated
    public boolean verifyId(boolean autoFix, boolean autoSave) throws RepositoryException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryUnwrap() throws IOException, RepositoryException {
        if (this.isValid()) {
            return;
        }
        if (this.node == null) {
            return;
        }
        VaultPackage pack = this.getPackage();
        Node content = this.getContent();
        if (content == null) {
            return;
        }
        boolean ok = false;
        try {
            content.addMixin("vlt:Package");
            Node defNode = content.addNode("vlt:definition");
            JcrPackageDefinitionImpl def = new JcrPackageDefinitionImpl(defNode);
            def.unwrap(pack, true, false);
            this.node.getSession().save();
            ok = true;
        }
        finally {
            if (!ok) {
                try {
                    this.node.getSession().refresh(false);
                }
                catch (RepositoryException repositoryException) {}
            }
        }
    }

    @Override
    public VaultPackage getPackage() throws RepositoryException, IOException {
        return this.getPackage(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected VaultPackage getPackage(boolean forceFileArchive) throws RepositoryException, IOException {
        if (forceFileArchive && this.pack != null && !(this.pack.getArchive() instanceof ZipArchive)) {
            this.pack.close();
            this.pack = null;
        }
        if (this.pack == null) {
            long size = -1L;
            try {
                Property data = this.getData();
                size = data == null ? -1L : data.getLength();
            }
            catch (RepositoryException data) {
                // empty catch block
            }
            if (!forceFileArchive && size >= 0L && size < 0x100000L) {
                JcrPackageDefinition def;
                MemoryArchive archive = new MemoryArchive(false);
                try (InputStream in = this.getData().getBinary().getStream();){
                    archive.run(in);
                }
                catch (Exception e) {
                    archive.close();
                    throw new IOException("Error while reading stream", e);
                }
                Properties props = archive.getMetaInf().getProperties();
                if ((props == null || props.isEmpty()) && (def = this.getDefinition()) != null) {
                    ((DefaultMetaInf)archive.getMetaInf()).setProperties(def.getMetaInf().getProperties());
                }
                this.pack = new ZipVaultPackage(archive, true);
            } else {
                File tmpFile = File.createTempFile("vaultpack", ".zip");
                Binary bin = this.getData().getBinary();
                try (FileOutputStream out = FileUtils.openOutputStream((File)tmpFile);
                     InputStream in = bin.getStream();){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    bin.dispose();
                }
                this.pack = new ZipVaultPackage(tmpFile, true);
            }
        }
        return this.pack;
    }

    @Override
    public void extract(ImportOptions opts) throws RepositoryException, PackageException, IOException {
        this.extract(opts, false, false);
    }

    @Override
    public void install(ImportOptions opts) throws RepositoryException, PackageException, IOException {
        this.extract(opts, true, false);
    }

    private void extract(ImportOptions options, boolean createSnapshot, boolean replaceSnapshot) throws RepositoryException, PackageException, IOException {
        this.extract(new HashSet<PackageId>(), options, createSnapshot, replaceSnapshot);
    }

    private void extract(Set<PackageId> processed, ImportOptions options, boolean createSnapshot, boolean replaceSnapshot) throws RepositoryException, PackageException, IOException {
        this.getPackage();
        this.getDefinition();
        if (this.def != null) {
            processed.add(this.def.getId());
        }
        if (options.getDependencyHandling() != null && options.getDependencyHandling() != DependencyHandling.IGNORE) {
            this.installDependencies(processed, options, createSnapshot, replaceSnapshot);
        }
        ImportOptions opts = options.copy();
        if (this.getDefinition().getBoolean("noIntermediateSaves")) {
            opts.setAutoSaveThreshold(0x7FFFFFFE);
        }
        InstallContextImpl ctx = this.pack.prepareExtract(this.node.getSession(), opts, this.mgr.getSecurityConfig());
        JcrPackage snap = null;
        if (!opts.isDryRun() && createSnapshot) {
            ExportOptions eOpts = new ExportOptions();
            eOpts.setListener(opts.getListener());
            snap = this.snapshot(eOpts, replaceSnapshot, opts.getAccessControlHandling());
        }
        ArrayList<String> subPackages = new ArrayList<String>();
        this.pack.extract(ctx, subPackages);
        if (this.def != null && !opts.isDryRun()) {
            this.def.touchLastUnpacked();
        }
        Session s = this.node.getSession();
        LinkedList<JcrPackageImpl> subPacks = new LinkedList<JcrPackageImpl>();
        HashMap<PackageId, PackageId> newerPackageIdPerSubPackage = new HashMap<PackageId, PackageId>();
        for (String path : subPackages) {
            if (!s.nodeExists(path)) continue;
            JcrPackageImpl p = new JcrPackageImpl(this.mgr, s.getNode(path));
            if (!p.isValid()) {
                try {
                    p.tryUnwrap();
                }
                catch (Exception e) {
                    log.info("Sub package {} not valid: " + e, (Object)path);
                }
            }
            if (!p.isValid()) continue;
            JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)p.getDefinition();
            PackageId pId = def.getId();
            String expectedPath = this.mgr.getInstallationPath(pId) + ".zip";
            if (!expectedPath.equals(path)) {
                if (s.nodeExists(expectedPath)) {
                    log.info("(Removed duplicated sub-package in {}. Still present at {}", (Object)path, (Object)expectedPath);
                    s.getNode(path).remove();
                    s.save();
                } else {
                    log.info("Moving sub-package in place: {} -> {}", (Object)path, (Object)expectedPath);
                    s.getWorkspace().move(path, expectedPath);
                }
                path = expectedPath;
                p.close();
                p = new JcrPackageImpl(this.mgr, s.getNode(path));
                def = (JcrPackageDefinitionImpl)p.getDefinition();
            }
            def.clearLastUnpacked(false);
            Dependency[] oldDeps = def.getDependencies();
            Dependency[] newDeps = DependencyUtil.addExact(oldDeps, this.pack.getId());
            if (oldDeps != newDeps) {
                def.setDependencies(newDeps, false);
            }
            String pName = pId.getName();
            Version pVersion = pId.getVersion();
            JcrPackageManagerImpl pkgMgr = new JcrPackageManagerImpl(this.mgr);
            List<JcrPackage> listPackages = pkgMgr.listPackages(pId.getGroup(), true);
            for (JcrPackage listedPackage : listPackages) {
                PackageId listedPackageId;
                JcrPackageDefinition listedPackageDef = listedPackage.getDefinition();
                if (listedPackageDef == null || (listedPackageId = listedPackageDef.getId()).equals(pId) || !pName.equals(listedPackageId.getName()) || !listedPackage.isValid() || !listedPackage.isInstalled() || listedPackageId.getVersion().compareTo(pVersion) <= 0) continue;
                newerPackageIdPerSubPackage.put(pId, listedPackageId);
                break;
            }
            subPacks.add(p);
        }
        if (!opts.isNonRecursive() && !subPacks.isEmpty()) {
            block32: {
                try {
                    DependencyUtil.sortPackages(subPacks);
                }
                catch (CyclicDependencyException e) {
                    if (!opts.isStrict()) break block32;
                    throw e;
                }
            }
            LinkedList<PackageId> subIds = new LinkedList<PackageId>();
            SubPackageHandling sb = this.pack.getSubPackageHandling();
            for (JcrPackageImpl p : subPacks) {
                PackageId newerPackageId;
                boolean skip = false;
                PackageId id = p.getDefinition().getId();
                SubPackageHandling.Option option = sb.getOption(id);
                String msg = null;
                if ((option == SubPackageHandling.Option.INSTALL || option == SubPackageHandling.Option.EXTRACT) && (newerPackageId = (PackageId)newerPackageIdPerSubPackage.get(id)) != null) {
                    msg = String.format("Skipping installation of subpackage '%s' due to newer installed version: '%s'", id, newerPackageId);
                    skip = true;
                }
                if (!skip) {
                    if (option == SubPackageHandling.Option.ADD || option == SubPackageHandling.Option.IGNORE) {
                        msg = "Skipping installation of subpackage " + id + " due to option " + (Object)((Object)option);
                        skip = true;
                    } else {
                        msg = option == SubPackageHandling.Option.INSTALL || option == SubPackageHandling.Option.FORCE_INSTALL ? "Starting installation of subpackage " + id : "Starting extraction of subpackage " + id;
                    }
                }
                if (options.isDryRun()) {
                    msg = "Dry run: " + msg;
                }
                if (options.getListener() != null) {
                    options.getListener().onMessage(ProgressTrackerListener.Mode.TEXT, msg, "");
                } else {
                    log.debug(msg);
                }
                if (!skip) {
                    if (createSnapshot && (option == SubPackageHandling.Option.INSTALL || option == SubPackageHandling.Option.FORCE_INSTALL)) {
                        p.extract(options, true, true);
                        subIds.add(id);
                    } else {
                        p.extract(options, false, true);
                    }
                }
                p.close();
            }
            if (snap != null) {
                ((JcrPackageDefinitionImpl)snap.getDefinition()).setSubPackages(subIds);
            }
            if (this.def != null) {
                this.def.setSubPackages(subIds);
            }
            s.save();
        }
        if (createSnapshot) {
            this.mgr.dispatch(PackageEvent.Type.INSTALL, this.def.getId(), null);
        } else {
            this.mgr.dispatch(PackageEvent.Type.EXTRACT, this.def.getId(), null);
        }
    }

    @Override
    @NotNull
    public PackageId[] extractSubpackages(@NotNull ImportOptions opts) throws RepositoryException, PackageException, IOException {
        HashSet<PackageId> processed = new HashSet<PackageId>();
        this.extractSubpackages(opts, processed);
        Object[] ret = processed.toArray(new PackageId[processed.size()]);
        Arrays.sort(ret);
        this.mgr.dispatch(PackageEvent.Type.EXTRACT_SUB_PACKAGES, this.getDefinition().getId(), (PackageId[])ret);
        return ret;
    }

    private void extractSubpackages(@NotNull ImportOptions opts, @NotNull Set<PackageId> processed) throws RepositoryException, PackageException, IOException {
        VaultPackage pack = this.getPackage();
        PackageId pId = pack.getId();
        Archive a = pack.getArchive();
        Archive.Entry packages = a.getEntry("/jcr_root/etc/packages");
        if (packages == null) {
            return;
        }
        LinkedList<Archive.Entry> entries = new LinkedList<Archive.Entry>();
        this.findSubPackageEntries(entries, packages);
        if (entries.isEmpty()) {
            log.debug("Package {} contains no sub-packages.", (Object)pId);
            return;
        }
        boolean hasOwnContent = false;
        for (PathFilterSet root : a.getMetaInf().getFilter().getFilterSets()) {
            if (Text.isDescendantOrEqual((String)"/etc/packages", (String)root.getRoot())) continue;
            log.debug("Package {}: contains content outside /etc/packages. Sub packages will have a dependency to it", (Object)pId);
            hasOwnContent = true;
            break;
        }
        if (!hasOwnContent) {
            DefaultNamePathResolver npResolver = new DefaultNamePathResolver(this.getNode().getSession());
            NodeTypeManager ntMgr = this.getNode().getSession().getWorkspace().getNodeTypeManager();
            block10: for (NodeTypeSet cnd : a.getMetaInf().getNodeTypes()) {
                for (Name name : cnd.getNodeTypes().keySet()) {
                    String jcrName;
                    try {
                        jcrName = npResolver.getJCRName(name);
                    }
                    catch (NamespaceException e) {
                        log.debug("Package {}: contains namespace not installed in the repository: {}. Sub packages will have a dependency to it", (Object)pId, (Object)name.getNamespaceURI());
                        hasOwnContent = true;
                        break block10;
                    }
                    if (ntMgr.hasNodeType(jcrName)) continue;
                    log.debug("Package {}: contains nodetype not installed in the repository: {}. Sub packages will have a dependency to it", (Object)pId, (Object)jcrName);
                    hasOwnContent = true;
                    break block10;
                }
            }
        }
        for (Archive.Entry e : entries) {
            VaultInputSource in = a.getInputSource(e);
            InputStream ins = in.getByteStream();
            try {
                try {
                    PackageId id = this.extractSubpackage(pId, ins, opts, processed, hasOwnContent);
                    log.debug("Package {}: Extracted sub-package: {}", (Object)pId, (Object)id);
                }
                catch (IOException e1) {
                    log.error("Package {}: Error while extracting subpackage {}: {}", new Object[]{pId, in.getSystemId(), e1});
                }
            }
            finally {
                if (ins == null) continue;
                ins.close();
            }
        }
        if (!entries.isEmpty() && !hasOwnContent) {
            log.debug("Package {}: is pure container package. marking as installed.", (Object)pId);
            this.getDefinition();
            if (this.def != null && !opts.isDryRun()) {
                this.def.touchLastUnpacked();
            }
        }
    }

    private PackageId extractSubpackage(@NotNull PackageId containerPackageId, @NotNull InputStream input, @NotNull ImportOptions opts, @NotNull Set<PackageId> processed, boolean hasOwnContent) throws RepositoryException, IOException, PackageException {
        PackageId subPid = this.mgr.register(input, true);
        try (JcrRegisteredPackage subPkg = (JcrRegisteredPackage)this.mgr.open(subPid);){
            Dependency[] newDeps;
            Dependency[] oldDeps;
            if (subPkg == null) {
                log.error("Package {}: Newly extracted subpackage is gone: {}", (Object)containerPackageId, (Object)subPid);
                PackageId packageId = null;
                return packageId;
            }
            JcrPackageImpl subPackage = (JcrPackageImpl)subPkg.getJcrPackage();
            if (hasOwnContent) {
                oldDeps = subPackage.getDefinition().getDependencies();
                if (oldDeps != (newDeps = DependencyUtil.addExact(oldDeps, containerPackageId))) {
                    subPackage.getDefinition().setDependencies(newDeps, true);
                }
            } else {
                newDeps = oldDeps = subPackage.getDefinition().getDependencies();
                for (Dependency d : this.getDefinition().getDependencies()) {
                    newDeps = DependencyUtil.add(newDeps, d);
                }
                if (oldDeps != newDeps) {
                    subPackage.getDefinition().setDependencies(newDeps, true);
                }
            }
            PackageId id = subPackage.getDefinition().getId();
            processed.add(id);
            if (!opts.isNonRecursive()) {
                subPackage.extractSubpackages(opts, processed);
            }
            PackageId packageId = id;
            return packageId;
        }
    }

    private void findSubPackageEntries(@NotNull List<Archive.Entry> entries, @NotNull Archive.Entry folder) {
        for (Archive.Entry entry : folder.getChildren()) {
            String name = entry.getName();
            if (entry.isDirectory()) {
                if (".snapshot".equals(name)) continue;
                this.findSubPackageEntries(entries, entry);
                continue;
            }
            if (!name.endsWith(".zip")) continue;
            entries.add(entry);
        }
    }

    @Override
    public Dependency[] getUnresolvedDependencies() throws RepositoryException {
        JcrPackageDefinition def = this.getDefinition();
        if (def == null) {
            return Dependency.EMPTY;
        }
        LinkedList<Dependency> unresolved = new LinkedList<Dependency>();
        for (Dependency dep : def.getDependencies()) {
            try {
                if (this.mgr.resolve(dep, true) != null) continue;
                unresolved.add(dep);
            }
            catch (IOException e) {
                if (e.getCause() instanceof RepositoryException) {
                    throw (RepositoryException)e.getCause();
                }
                throw new RepositoryException((Throwable)e);
            }
        }
        return unresolved.toArray(new Dependency[unresolved.size()]);
    }

    @Override
    public PackageId[] getResolvedDependencies() throws RepositoryException {
        JcrPackageDefinition def = this.getDefinition();
        if (def == null) {
            return PackageId.EMPTY;
        }
        LinkedList<PackageId> resolved = new LinkedList<PackageId>();
        for (Dependency dep : def.getDependencies()) {
            try {
                PackageId id = this.mgr.resolve(dep, true);
                if (id == null) continue;
                resolved.add(id);
            }
            catch (IOException e) {
                if (e.getCause() instanceof RepositoryException) {
                    throw (RepositoryException)e.getCause();
                }
                throw new RepositoryException((Throwable)e);
            }
        }
        return resolved.toArray(new PackageId[resolved.size()]);
    }

    private void installDependencies(Set<PackageId> processed, ImportOptions opts, boolean createSnapshot, boolean replaceSnapshot) throws PackageException, RepositoryException, IOException {
        if (this.def == null) {
            return;
        }
        LinkedList<Dependency> unresolved = new LinkedList<Dependency>();
        LinkedList<RegisteredPackage> uninstalled = new LinkedList<RegisteredPackage>();
        for (Dependency dep : this.def.getDependencies()) {
            PackageId id = this.mgr.resolve(dep, false);
            if (id == null) {
                unresolved.add(dep);
                continue;
            }
            RegisteredPackage pack = this.mgr.open(id);
            if (pack == null || pack.isInstalled()) continue;
            unresolved.add(dep);
            uninstalled.add(pack);
        }
        if (unresolved.size() == 0) {
            return;
        }
        if (opts.getDependencyHandling() == DependencyHandling.STRICT && unresolved.size() > 0 || opts.getDependencyHandling() == DependencyHandling.REQUIRED && unresolved.size() > uninstalled.size()) {
            String msg = String.format("Refusing to install package %s. required dependencies missing: %s", this.def.getId(), unresolved);
            log.error(msg);
            throw new DependencyException(msg);
        }
        for (RegisteredPackage pack : uninstalled) {
            String msg;
            if (pack.isInstalled()) continue;
            PackageId packageId = pack.getId();
            if (processed.contains(packageId)) {
                if (opts.getDependencyHandling() == DependencyHandling.BEST_EFFORT) continue;
                msg = String.format("Unable to install package %s. dependency has as cycling reference to %s", this.def.getId(), packageId);
                log.error(msg);
                throw new CyclicDependencyException(msg);
            }
            if (pack instanceof JcrRegisteredPackage) {
                JcrPackage jcrPackage = ((JcrRegisteredPackage)pack).getJcrPackage();
                ((JcrPackageImpl)jcrPackage).extract(processed, opts, createSnapshot, replaceSnapshot);
                continue;
            }
            msg = String.format("Unable to install package %s. dependency not found in JcrPackageRegistry %s", this.def.getId(), packageId);
            log.error(msg);
            throw new DependencyException(msg);
        }
    }

    private void uninstallUsages(Set<PackageId> processed, ImportOptions opts) throws PackageException, RepositoryException, IOException {
        if (this.def == null) {
            return;
        }
        Object[] usage = this.mgr.usage(this.getDefinition().getId());
        if (usage.length > 0 && opts.getDependencyHandling() == DependencyHandling.STRICT) {
            String msg = String.format("Refusing to uninstall package %s. it is still used by: %s", this.def.getId(), Arrays.toString(usage));
            log.error(msg);
            throw new DependencyException(msg);
        }
        for (PackageId packageId : usage) {
            try (JcrRegisteredPackage pack = (JcrRegisteredPackage)this.mgr.open(packageId);){
                PackageId packageId2;
                if (pack == null || !pack.isInstalled() || processed.contains(packageId2 = pack.getId())) continue;
                ((JcrPackageImpl)pack.getJcrPackage()).uninstall(processed, opts);
            }
        }
    }

    @Override
    public JcrPackage snapshot(ExportOptions opts, boolean replace) throws RepositoryException, PackageException, IOException {
        return this.snapshot(opts, replace, null);
    }

    @Nullable
    private JcrPackage snapshot(@NotNull ExportOptions opts, boolean replace, @Nullable AccessControlHandling acHandling) throws RepositoryException, PackageException, IOException {
        JcrPackageDefinitionImpl myDef;
        WorkspaceFilter filter;
        if (this.node == null) {
            return null;
        }
        PackageId id = this.getSnapshotId();
        Node packNode = this.getSnapshotNode();
        if (packNode != null) {
            if (!replace) {
                log.debug("Refusing to recreate snapshot {}, already exists.", (Object)id);
                return null;
            }
            packNode.remove();
            this.node.getSession().save();
        }
        if ((filter = (myDef = (JcrPackageDefinitionImpl)this.getDefinition()).getMetaInf().getFilter()) == null || filter.getFilterSets().isEmpty()) {
            log.info("Refusing to create snapshot {} due to empty filters", (Object)id);
            return null;
        }
        for (PathFilterSet set : filter.getFilterSets()) {
            if (!"".equals(set.getRoot()) && !"/".equals(set.getRoot()) || !set.getEntries().isEmpty()) continue;
            log.info("Refusing to create snapshot {} due to / only filter", (Object)id);
            return null;
        }
        log.debug("Creating snapshot for {}.", (Object)id);
        JcrPackageManagerImpl packMgr = new JcrPackageManagerImpl(this.mgr);
        String path = this.mgr.getInstallationPath(id);
        String parentPath = Text.getRelativeParent((String)path, (int)1);
        Node folder = packMgr.mkdir(parentPath, true);
        JcrPackage snap = this.mgr.createNew(folder, id, null, true);
        JcrPackageDefinitionImpl snapDef = (JcrPackageDefinitionImpl)snap.getDefinition();
        snapDef.setId(id, false);
        snapDef.setFilter(filter, false);
        snapDef.set("jcr:description", "Snapshot of package " + myDef.getId().toString(), false);
        if (acHandling == null) {
            snapDef.set("acHandling", myDef.get("acHandling"), false);
        } else {
            snapDef.set("acHandling", acHandling.name(), false);
        }
        if (opts.getListener() != null) {
            opts.getListener().onMessage(ProgressTrackerListener.Mode.TEXT, "Creating snapshot for package " + myDef.getId(), "");
        }
        packMgr.assemble(snap.getNode(), snapDef, opts.getListener());
        log.debug("Creating snapshot for {} completed.", (Object)id);
        this.mgr.dispatch(PackageEvent.Type.SNAPSHOT, id, null);
        return snap;
    }

    @Nullable
    private Node getSnapshotNode() throws RepositoryException {
        if (this.node == null) {
            return null;
        }
        String path = this.node.getParent().getPath() + "/.snapshot/" + this.node.getName();
        if (this.node.getSession().nodeExists(path)) {
            return this.node.getSession().getNode(path);
        }
        if (this.node.getSession().nodeExists(path + ".zip")) {
            return this.node.getSession().getNode(path + ".zip");
        }
        return null;
    }

    @Override
    public JcrPackage getSnapshot() throws RepositoryException {
        JcrPackageImpl snap;
        Node packNode = this.getSnapshotNode();
        if (packNode != null && (snap = new JcrPackageImpl(this.mgr, packNode)).isValid()) {
            return snap;
        }
        return null;
    }

    private PackageId getSnapshotId() throws RepositoryException {
        PackageId id = this.getDefinition().getId();
        String group = id.getGroup();
        group = group.length() == 0 ? ".snapshot" : group + "/.snapshot";
        return new PackageId(group, id.getName(), id.getVersion());
    }

    @Override
    public void uninstall(ImportOptions opts) throws RepositoryException, PackageException, IOException {
        this.uninstall(new HashSet<PackageId>(), opts);
    }

    private void uninstall(Set<PackageId> processed, ImportOptions opts) throws RepositoryException, PackageException, IOException {
        JcrPackage snap;
        List<PackageId> subPackages;
        this.getDefinition();
        if (this.def != null) {
            processed.add(this.def.getId());
        }
        if (opts.getDependencyHandling() != null && opts.getDependencyHandling() != DependencyHandling.IGNORE) {
            this.uninstallUsages(processed, opts);
        }
        List<PackageId> list = subPackages = (snap = this.getSnapshot()) == null ? this.def.getSubPackages() : ((JcrPackageDefinitionImpl)snap.getDefinition()).getSubPackages();
        if (snap == null) {
            if (opts.isStrict()) {
                throw new PackageException("Unable to uninstall package. No snapshot present.");
            }
            log.warn("Unable to revert package content {}. Snapshot missing.", (Object)this.getDefinition().getId());
            if (opts.getListener() != null) {
                opts.getListener().onMessage(ProgressTrackerListener.Mode.TEXT, "Unable to revert package content. Snapshot missing.", "");
            }
        } else {
            Session s = this.getNode().getSession();
            if (!opts.isNonRecursive() && subPackages.size() > 0) {
                JcrPackageManagerImpl packMgr = new JcrPackageManagerImpl(this.mgr);
                for (PackageId id : subPackages) {
                    try (JcrPackage pack = packMgr.open(id);){
                        if (pack == null) continue;
                        if (pack.getSnapshot() == null) {
                            log.warn("Unable to uninstall sub package {}. Snapshot missing.", (Object)id);
                            continue;
                        }
                        pack.uninstall(opts);
                    }
                }
            }
            if (opts.getListener() != null) {
                opts.getListener().onMessage(ProgressTrackerListener.Mode.TEXT, "Uninstalling package from snapshot " + snap.getDefinition().getId(), "");
            }
            opts.setImportMode(ImportMode.REPLACE);
            snap.extract(opts);
            snap.getNode().remove();
            s.save();
        }
        if (!opts.isNonRecursive() || snap != null) {
            for (PackageId id : subPackages) {
                if (!this.mgr.contains(id)) continue;
                this.mgr.remove(id);
            }
        }
        JcrPackageDefinitionImpl def = (JcrPackageDefinitionImpl)this.getDefinition();
        def.clearLastUnpacked(true);
        this.mgr.dispatch(PackageEvent.Type.UNINSTALL, def.getId(), null);
    }

    @Override
    public long getSize() {
        try {
            this.assertValid();
            return this.getData().getLength();
        }
        catch (RepositoryException e) {
            log.error("Error during getSize()", (Throwable)e);
            return -1L;
        }
    }

    @Override
    public void close() {
        this.node = null;
        if (this.pack != null) {
            this.pack.close();
            this.pack = null;
        }
    }

    @Nullable
    private Node getContent() throws RepositoryException {
        return this.node == null ? null : this.node.getNode("jcr:content");
    }

    @Override
    @Nullable
    public Property getData() throws RepositoryException {
        Node content = this.getContent();
        return content == null ? null : content.getProperty("jcr:data");
    }

    @Override
    @Nullable
    public Node getDefNode() throws RepositoryException {
        Node content = this.getContent();
        return content != null && content.hasNode("vlt:definition") ? content.getNode("vlt:definition") : null;
    }

    private void assertValid() throws RepositoryException {
        if (!this.isValid()) {
            throw new IllegalArgumentException("not a valid package.");
        }
    }
}

