/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.impl;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.sling.repoinit.parser.RepoInitParser;
import org.apache.sling.repoinit.parser.RepoInitParsingException;
import org.apache.sling.repoinit.parser.impl.ParseException;
import org.apache.sling.repoinit.parser.impl.RepoInitParserImpl;
import org.apache.sling.repoinit.parser.impl.TokenMgrError;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.osgi.service.component.annotations.Component;

@Component(service={RepoInitParser.class}, property={"service.vendor=The Apache Software Foundation"})
public class RepoInitParserService
implements RepoInitParser {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Operation> parse(Reader r) throws RepoInitParsingException {
        try {
            Throwable throwable = null;
            try (AddTailingLinefeedFilterReader readerWrapper = new AddTailingLinefeedFilterReader(r);){
                List<Operation> list = new RepoInitParserImpl(readerWrapper).parse();
                return list;
            }
            catch (TokenMgrError tme) {
                try {
                    throw new RepoInitParsingException(tme.getMessage(), tme);
                    catch (ParseException pe) {
                        throw new RepoInitParsingException(pe.getMessage(), pe);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException ioe) {
            throw new RepoInitParsingException(ioe.getMessage(), ioe);
        }
    }

    private static final class AddTailingLinefeedFilterReader
    extends FilterReader {
        private boolean alreadyAddedNewline;

        protected AddTailingLinefeedFilterReader(Reader in) {
            super(in);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int result = super.read(cbuf, off, len);
            if (result == -1 && !this.alreadyAddedNewline) {
                cbuf[off] = 10;
                this.alreadyAddedNewline = true;
                return 1;
            }
            return result;
        }
    }
}

