/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.handlers.AbstractContentPackageHandler;
import org.apache.sling.feature.cpconverter.handlers.BundleEntryHandler;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlingInitialContentBundleHandler
extends BundleEntryHandler {
    @NotNull
    private final AbstractContentPackageHandler handler;

    public SlingInitialContentBundleHandler(@NotNull AbstractContentPackageHandler handler, @NotNull ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy) {
        this.handler = handler;
        this.setSlingInitialContentPolicy(slingInitialContentPolicy);
    }

    @Override
    void processBundleInputStream(@NotNull String path, @NotNull Path originalBundleFile, @NotNull String bundleName, @Nullable String runMode, @Nullable Integer startLevel, @NotNull ContentPackage2FeatureModelConverter converter) throws IOException, ConverterException {
        try (JarFile jarFile = new JarFile(originalBundleFile.toFile());){
            ArtifactId id = this.extractArtifactId(bundleName, jarFile);
            InputStream ignored = this.extractSlingInitialContent(path, originalBundleFile, id, jarFile, converter, runMode);
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    @Override
    void finalizePackageAssembly(@NotNull String path, @NotNull Map<PackageType, VaultPackageAssembler> packageAssemblers, @NotNull ContentPackage2FeatureModelConverter converter, @Nullable String runMode) throws IOException, ConverterException {
        for (Map.Entry<PackageType, VaultPackageAssembler> entry : packageAssemblers.entrySet()) {
            File packageFile = entry.getValue().createPackage();
            this.handler.processSubPackage(path + "-" + entry.getKey(), runMode, converter.open(packageFile), converter, true);
        }
    }
}

