/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.shared;

import java.io.Closeable;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.distribution.journal.messages.LogMessage;
import org.apache.sling.distribution.journal.shared.DefaultDistributionLog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DistributionLogEventListener
implements EventHandler,
Closeable {
    private static final String[] TOPICS = new String[]{"org/apache/sling/distribution/journal/log", "org/apache/sling/distribution/agent/package/distributed"};
    private final String pubAgentName;
    private final ServiceRegistration<EventHandler> reg;
    private final DefaultDistributionLog log;
    private static final String MESSAGE_AND_STACKTRACE = "Message: {},\nStacktrace: {}";

    public DistributionLogEventListener(BundleContext context, DefaultDistributionLog log, String pubAgentName) {
        this.log = log;
        this.pubAgentName = pubAgentName;
        Hashtable<String, String[]> eventHandlerProps = new Hashtable<String, String[]>();
        ((Dictionary)eventHandlerProps).put("event.topics", TOPICS);
        this.reg = context.registerService(EventHandler.class, (Object)this, eventHandlerProps);
    }

    public void handleEvent(Event event) {
        if ("org/apache/sling/distribution/agent/package/distributed".equals(event.getTopic())) {
            this.handleDistributedEvent(event);
        } else if ("org/apache/sling/distribution/journal/log".equals(event.getTopic())) {
            this.handleLogEvent(event);
        }
    }

    private void handleLogEvent(Event event) {
        LogMessage logMessage = (LogMessage)event.getProperty("message");
        if (!this.pubAgentName.equals(logMessage.getPubAgentName())) {
            return;
        }
        if (logMessage.getStacktrace() == null) {
            this.log.info(logMessage.getMessage(), new Object[0]);
        } else {
            this.log.warn(MESSAGE_AND_STACKTRACE, logMessage.getMessage(), logMessage.getStacktrace());
        }
    }

    private void handleDistributedEvent(Event event) {
        String agentName = (String)event.getProperty("distribution.component.name");
        if (!this.pubAgentName.equals(agentName)) {
            return;
        }
        String[] paths = (String[])event.getProperty("distribution.paths");
        String type = (String)event.getProperty("distribution.type");
        String packageId = (String)event.getProperty("distribution.package.id");
        this.log.info("Successfully applied package with id {}, type {}, paths {}", packageId, type, paths);
    }

    @Override
    public void close() {
        if (this.reg != null) {
            this.reg.unregister();
        }
    }
}

