/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.util.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

final class ByteBufferBackedInputStream
extends InputStream {
    private final ByteBuffer memory;
    private final FileInputStream fileInputStream;

    public ByteBufferBackedInputStream(ByteBuffer memory, File file) throws IOException {
        this.memory = memory;
        this.fileInputStream = file != null ? new FileInputStream(file) : null;
    }

    @Override
    public int read() throws IOException {
        if (!this.memory.hasRemaining()) {
            if (this.fileInputStream != null) {
                return this.fileInputStream.read();
            }
            return -1;
        }
        return this.memory.get() & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) throws IOException {
        if (!this.memory.hasRemaining()) {
            if (this.fileInputStream != null) {
                return this.fileInputStream.read(bytes, off, len);
            }
            return -1;
        }
        len = Math.min(len, this.memory.remaining());
        this.memory.get(bytes, off, len);
        return len;
    }
}

