/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its.setup;

import java.util.UUID;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.base.commons.BaseDiscoveryService;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.commons.ViewChecker;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistryImpl;
import org.apache.sling.discovery.base.connectors.ping.ConnectorRegistry;
import org.apache.sling.discovery.base.connectors.ping.ConnectorRegistryImpl;
import org.apache.sling.discovery.base.its.setup.ModifiableTestBaseConfig;
import org.apache.sling.discovery.base.its.setup.VirtualInstance;
import org.apache.sling.discovery.base.its.setup.mock.ArtificialDelay;
import org.apache.sling.discovery.base.its.setup.mock.FailingScheduler;
import org.apache.sling.discovery.commons.providers.base.DummyScheduler;
import org.apache.sling.discovery.commons.providers.spi.base.DummySlingSettingsService;
import org.apache.sling.settings.SlingSettingsService;

public abstract class VirtualInstanceBuilder {
    private static Scheduler singletonScheduler = null;
    private String debugName;
    protected ResourceResolverFactory factory;
    private boolean resetRepo;
    private String slingId = UUID.randomUUID().toString();
    private ClusterViewService clusterViewService;
    protected ViewChecker viewChecker;
    private AnnouncementRegistry announcementRegistry;
    private ConnectorRegistry connectorRegistry;
    private Scheduler scheduler;
    private BaseDiscoveryService discoveryService;
    private SlingSettingsService slingSettingsService;
    protected boolean ownRepository;
    private int minEventDelay = 1;
    protected VirtualInstanceBuilder hookedToBuilder;
    protected final ArtificialDelay delay = new ArtificialDelay();

    public static Scheduler getSingletonScheduler() throws Exception {
        if (singletonScheduler == null) {
            singletonScheduler = new DummyScheduler();
        }
        return singletonScheduler;
    }

    public ArtificialDelay getDelay() {
        return this.delay;
    }

    public VirtualInstanceBuilder newRepository(String path, boolean resetRepo) throws Exception {
        this.createNewRepository();
        this.ownRepository = true;
        this.resetRepo = resetRepo;
        this.setPath(path);
        return this;
    }

    public abstract VirtualInstanceBuilder createNewRepository() throws Exception;

    public VirtualInstanceBuilder useRepositoryOf(VirtualInstance other) throws Exception {
        return this.useRepositoryOf(other.getBuilder());
    }

    public VirtualInstanceBuilder useRepositoryOf(VirtualInstanceBuilder other) throws Exception {
        this.factory = other.factory;
        this.hookedToBuilder = other;
        this.ownRepository = false;
        return this;
    }

    public VirtualInstanceBuilder setConnectorPingTimeout(int connectorPingTimeout) {
        this.getConnectorConfig().setViewCheckTimeout(connectorPingTimeout);
        return this;
    }

    public VirtualInstanceBuilder setConnectorPingInterval(int connectorPingInterval) {
        this.getConnectorConfig().setViewCheckInterval(connectorPingInterval);
        return this;
    }

    public boolean isResetRepo() {
        return this.resetRepo;
    }

    public String getSlingId() {
        return this.slingId;
    }

    public String getDebugName() {
        return this.debugName;
    }

    public ResourceResolverFactory getResourceResolverFactory() {
        return this.factory;
    }

    public ClusterViewService getClusterViewService() {
        if (this.clusterViewService == null) {
            this.clusterViewService = this.createClusterViewService();
        }
        return this.clusterViewService;
    }

    protected abstract ClusterViewService createClusterViewService();

    public ViewChecker getViewChecker() throws Exception {
        if (this.viewChecker == null) {
            this.viewChecker = this.createViewChecker();
        }
        return this.viewChecker;
    }

    public AnnouncementRegistry getAnnouncementRegistry() {
        if (this.announcementRegistry == null) {
            this.announcementRegistry = this.createAnnouncementRegistry();
        }
        return this.announcementRegistry;
    }

    protected AnnouncementRegistry createAnnouncementRegistry() {
        return AnnouncementRegistryImpl.testConstructor((ResourceResolverFactory)this.getResourceResolverFactory(), (SlingSettingsService)this.getSlingSettingsService(), (BaseConfig)this.getConnectorConfig());
    }

    public ConnectorRegistry getConnectorRegistry() {
        if (this.connectorRegistry == null) {
            this.connectorRegistry = this.createConnectorRegistry();
        }
        return this.connectorRegistry;
    }

    protected ConnectorRegistry createConnectorRegistry() {
        return ConnectorRegistryImpl.testConstructor((AnnouncementRegistry)this.announcementRegistry, (BaseConfig)this.getConnectorConfig());
    }

    protected abstract ViewChecker createViewChecker() throws Exception;

    protected abstract VirtualInstanceBuilder setPath(String var1);

    public VirtualInstanceBuilder setDebugName(String debugName) {
        this.debugName = debugName;
        this.delay.setDebugName(debugName);
        return this;
    }

    public abstract ModifiableTestBaseConfig getConnectorConfig();

    public void setScheduler(Scheduler singletonScheduler) {
        this.scheduler = singletonScheduler;
    }

    public Scheduler getScheduler() throws Exception {
        if (this.scheduler == null) {
            this.scheduler = VirtualInstanceBuilder.getSingletonScheduler();
        }
        return this.scheduler;
    }

    public BaseDiscoveryService getDiscoverService() throws Exception {
        if (this.discoveryService == null) {
            this.discoveryService = this.createDiscoveryService();
        }
        return this.discoveryService;
    }

    protected abstract BaseDiscoveryService createDiscoveryService() throws Exception;

    protected SlingSettingsService getSlingSettingsService() {
        if (this.slingSettingsService == null) {
            this.slingSettingsService = this.createSlingSettingsService();
        }
        return this.slingSettingsService;
    }

    protected SlingSettingsService createSlingSettingsService() {
        return new DummySlingSettingsService(this.getSlingId());
    }

    public abstract Object[] getAdditionalServices(VirtualInstance var1) throws Exception;

    public VirtualInstanceBuilder setMinEventDelay(int minEventDelay) {
        this.minEventDelay = minEventDelay;
        return this;
    }

    public int getMinEventDelay() {
        return this.minEventDelay;
    }

    public VirtualInstance build() throws Exception {
        return new VirtualInstance(this);
    }

    public VirtualInstanceBuilder setSlingId(String slingId) {
        this.slingId = slingId;
        return this;
    }

    public VirtualInstanceBuilder withFailingScheduler(boolean useFailingScheduler) {
        if (useFailingScheduler) {
            this.scheduler = new FailingScheduler();
        }
        return this;
    }

    protected abstract void resetRepo() throws Exception;
}

