/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its.setup;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import junitx.util.PrivateAccessor;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.PropertyProvider;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.base.commons.BaseDiscoveryService;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;
import org.apache.sling.discovery.base.commons.ViewChecker;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.connectors.ping.ConnectorRegistry;
import org.apache.sling.discovery.base.connectors.ping.TopologyConnectorClientInformation;
import org.apache.sling.discovery.base.connectors.ping.TopologyConnectorServlet;
import org.apache.sling.discovery.base.its.setup.ModifiableTestBaseConfig;
import org.apache.sling.discovery.base.its.setup.OSGiMock;
import org.apache.sling.discovery.base.its.setup.VirtualInstanceBuilder;
import org.apache.sling.discovery.base.its.setup.VirtualInstanceHelper;
import org.apache.sling.discovery.base.its.setup.mock.ArtificialDelay;
import org.apache.sling.discovery.base.its.setup.mock.DummyResourceResolverFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualInstance {
    protected static final Logger logger = LoggerFactory.getLogger(VirtualInstance.class);
    public final String slingId;
    ClusterViewService clusterViewService;
    private final ResourceResolverFactory resourceResolverFactory;
    private final OSGiMock osgiMock;
    private final BaseDiscoveryService discoveryService;
    private final AnnouncementRegistry announcementRegistry;
    private final ConnectorRegistry connectorRegistry;
    protected final String debugName;
    private ResourceResolver resourceResolver;
    private int serviceId = 999;
    private ViewCheckerRunner viewCheckerRunner = null;
    private ServletContextHandler servletContext;
    private Server jettyServer;
    private ModifiableTestBaseConfig config;
    private ViewChecker viewChecker;
    private final VirtualInstanceBuilder builder;
    private final ArtificialDelay delay;

    public VirtualInstance(VirtualInstanceBuilder builder) throws Exception {
        this.builder = builder;
        this.slingId = builder.getSlingId();
        this.debugName = builder.getDebugName();
        this.delay = builder.getDelay();
        logger.info("<init>: starting slingId=" + this.slingId + ", debugName=" + this.debugName);
        this.osgiMock = new OSGiMock();
        this.resourceResolverFactory = builder.getResourceResolverFactory();
        this.config = builder.getConnectorConfig();
        this.config.addTopologyConnectorWhitelistEntry("127.0.0.1");
        this.config.setMinEventDelay(builder.getMinEventDelay());
        this.clusterViewService = builder.getClusterViewService();
        this.announcementRegistry = builder.getAnnouncementRegistry();
        this.connectorRegistry = builder.getConnectorRegistry();
        this.viewChecker = builder.getViewChecker();
        this.discoveryService = builder.getDiscoverService();
        this.osgiMock.addService(this.clusterViewService);
        this.osgiMock.addService(this.announcementRegistry);
        this.osgiMock.addService(this.connectorRegistry);
        this.osgiMock.addService(this.viewChecker);
        this.osgiMock.addService(this.discoveryService);
        this.osgiMock.addServices(builder.getAdditionalServices(this));
        this.resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
        if (builder.isResetRepo()) {
            builder.resetRepo();
        }
        this.osgiMock.activateAll();
    }

    public void setDelay(String operationDescriptor, long delayMillis) {
        this.delay.setDelay(operationDescriptor, delayMillis);
    }

    public String toString() {
        return "a [Test]Instance[slingId=" + this.slingId + ", debugName=" + this.debugName + "]";
    }

    public void bindPropertyProvider(PropertyProvider propertyProvider, String ... propertyNames) throws Throwable {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("service.id", Long.valueOf(this.serviceId++));
        props.put("instance.properties", propertyNames);
        PrivateAccessor.invoke((Object)this.discoveryService, (String)"bindPropertyProvider", (Class[])new Class[]{PropertyProvider.class, Map.class}, (Object[])new Object[]{propertyProvider, props});
    }

    public String getSlingId() {
        return this.slingId;
    }

    public ClusterViewService getClusterViewService() {
        return this.clusterViewService;
    }

    public BaseDiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public AnnouncementRegistry getAnnouncementRegistry() {
        return this.announcementRegistry;
    }

    public synchronized void startJetty() throws Throwable {
        if (this.jettyServer != null) {
            return;
        }
        this.servletContext = new ServletContextHandler(0);
        this.servletContext.setContextPath("/");
        TopologyConnectorServlet servlet = new TopologyConnectorServlet();
        PrivateAccessor.setField((Object)servlet, (String)"config", (Object)this.config);
        PrivateAccessor.setField((Object)servlet, (String)"clusterViewService", (Object)this.clusterViewService);
        PrivateAccessor.setField((Object)servlet, (String)"announcementRegistry", (Object)this.announcementRegistry);
        JUnit4Mockery context = new JUnit4Mockery();
        final HttpService httpService = (HttpService)context.mock(HttpService.class);
        context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpService)this.allowing(httpService)).registerServlet((String)this.with(1.any(String.class)), (Servlet)this.with(1.any(Servlet.class)), (Dictionary)this.with(1.any(Dictionary.class)), (HttpContext)this.with(1.any(HttpContext.class)));
            }
        });
        PrivateAccessor.setField((Object)servlet, (String)"httpService", (Object)httpService);
        Object cc = null;
        PrivateAccessor.invoke((Object)servlet, (String)"activate", (Class[])new Class[]{ComponentContext.class}, (Object[])new Object[]{cc});
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        this.servletContext.addServlet(holder, "/system/console/topology/*");
        this.jettyServer = new Server();
        this.jettyServer.setHandler((Handler)this.servletContext);
        SelectChannelConnector connector = new SelectChannelConnector();
        this.jettyServer.setConnectors(new Connector[]{connector});
        this.jettyServer.start();
    }

    public synchronized int getJettyPort() {
        if (this.jettyServer == null) {
            throw new IllegalStateException("jettyServer not started");
        }
        Connector[] connectors = this.jettyServer.getConnectors();
        return connectors[0].getLocalPort();
    }

    public TopologyConnectorClientInformation connectTo(String url) throws MalformedURLException {
        return this.connectorRegistry.registerOutgoingConnector(this.clusterViewService, new URL(url));
    }

    public InstanceDescription getLocalInstanceDescription() throws UndefinedClusterViewException {
        for (InstanceDescription id : this.getClusterViewService().getLocalClusterView().getInstances()) {
            if (!this.slingId.equals(id.getSlingId())) continue;
            return id;
        }
        Assert.fail((String)"no local instanceDescription found");
        return null;
    }

    public void heartbeatsAndCheckView() {
        logger.info("Instance [" + this.slingId + "] issues a pulse now " + new Date());
        this.viewChecker.heartbeatAndCheckView();
    }

    public void startViewChecker(int intervalInSeconds) throws IllegalAccessException, InvocationTargetException {
        logger.info("startViewChecker: intervalInSeconds=" + intervalInSeconds);
        if (this.viewCheckerRunner != null) {
            logger.info("startViewChecker: stopping first...");
            this.viewCheckerRunner.stop();
            logger.info("startViewChecker: stopped.");
        }
        logger.info("startViewChecker: activating...");
        try {
            OSGiMock.activate(this.viewChecker);
        }
        catch (Error er) {
            er.printStackTrace(System.out);
            throw er;
        }
        catch (RuntimeException re) {
            re.printStackTrace(System.out);
        }
        logger.info("startViewChecker: initializing...");
        this.viewCheckerRunner = new ViewCheckerRunner(intervalInSeconds);
        Thread th = new Thread((Runnable)this.viewCheckerRunner, "Test-ViewCheckerRunner [" + this.debugName + "]");
        th.setDaemon(true);
        logger.info("startViewChecker: starting thread...");
        th.start();
        logger.info("startViewChecker: done.");
    }

    public boolean isViewCheckerRunning() {
        return this.viewCheckerRunner != null;
    }

    public void stopViewChecker() throws Throwable {
        if (this.viewCheckerRunner != null) {
            this.viewCheckerRunner.stop();
            while (!this.viewCheckerRunner.hasStopped()) {
                logger.info("stopViewChecker: [" + this.getDebugName() + "] waiting for viewCheckerRunner to stop");
                Thread.sleep(500L);
            }
            logger.info("stopViewChecker: [" + this.getDebugName() + "] viewCheckerRunner stopped");
            this.viewCheckerRunner = null;
        }
        try {
            OSGiMock.deactivate(this.viewChecker);
        }
        catch (Error er) {
            er.printStackTrace(System.out);
            throw er;
        }
        catch (RuntimeException re) {
            re.printStackTrace(System.out);
            throw re;
        }
    }

    public void dumpRepo() throws Exception {
        VirtualInstanceHelper.dumpRepo(this.resourceResolverFactory);
    }

    public ResourceResolverFactory getResourceResolverFactory() {
        return this.resourceResolverFactory;
    }

    public void stop() throws Exception {
        logger.info("stop: stopping slingId=" + this.slingId + ", debugName=" + this.debugName);
        try {
            this.stopViewChecker();
        }
        catch (Throwable e) {
            throw new Exception("Caught Throwable in stop(): " + e, e);
        }
        if (this.resourceResolver != null) {
            this.resourceResolver.close();
        }
        this.osgiMock.deactivateAll();
        logger.info("stop: stopped slingId=" + this.slingId + ", debugName=" + this.debugName);
    }

    public void bindTopologyEventListener(TopologyEventListener eventListener) throws Throwable {
        PrivateAccessor.invoke((Object)this.discoveryService, (String)"bindTopologyEventListener", (Class[])new Class[]{TopologyEventListener.class}, (Object[])new Object[]{eventListener});
    }

    public ModifiableTestBaseConfig getConfig() {
        return this.config;
    }

    public ViewChecker getViewChecker() {
        return this.viewChecker;
    }

    public void assertEstablishedView() {
        Assert.assertTrue((boolean)this.getDiscoveryService().getTopology().isCurrent());
    }

    public VirtualInstanceBuilder getBuilder() {
        return this.builder;
    }

    public String getDebugName() {
        return this.debugName;
    }

    public void shutdownRepository() throws NoSuchFieldException {
        JackrabbitRepository jr = this.getRepository();
        jr.shutdown();
    }

    public JackrabbitRepository getRepository() throws NoSuchFieldException {
        if (!(this.resourceResolverFactory instanceof DummyResourceResolverFactory)) {
            throw new IllegalStateException("expected a DummyResourceResolverFactory, got a " + this.resourceResolverFactory);
        }
        DummyResourceResolverFactory f = (DummyResourceResolverFactory)this.resourceResolverFactory;
        return f.getJackrabbitRepository();
    }

    private class ViewCheckerRunner
    implements Runnable {
        private final int intervalInSeconds;
        private boolean stopping_ = false;
        private volatile boolean stopped_ = false;

        public ViewCheckerRunner(int intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        public synchronized void stop() {
            logger.info("Stopping Instance [" + VirtualInstance.this.slingId + "]");
            this.stopping_ = true;
            this.notifyAll();
        }

        public boolean hasStopped() {
            return this.stopped_;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            finally {
                this.stopped_ = true;
                logger.info("Instance [" + VirtualInstance.this.slingId + "] stopped.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() {
            while (true) {
                ViewCheckerRunner viewCheckerRunner = this;
                synchronized (viewCheckerRunner) {
                    if (this.stopping_) {
                        logger.info("Instance [" + VirtualInstance.this.slingId + "] stopps.");
                        return;
                    }
                }
                try {
                    VirtualInstance.this.heartbeatsAndCheckView();
                }
                catch (Exception e) {
                    logger.error("run: ping connector for slingId=" + VirtualInstance.this.slingId + " threw exception: " + e, (Throwable)e);
                }
                viewCheckerRunner = this;
                synchronized (viewCheckerRunner) {
                    try {
                        this.wait(this.intervalInSeconds * 1000);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }
        }
    }
}

