/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.crypto.internal;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import org.apache.sling.commons.crypto.SaltProvider;
import org.apache.sling.commons.crypto.internal.SecureRandomSaltProviderConfiguration;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Apache Sling Commons Crypto \u2013 SecureRandom Salt Provider", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=SecureRandomSaltProviderConfiguration.class, factory=true)
public final class SecureRandomSaltProvider
implements SaltProvider {
    private SecureRandom secureRandom;
    private SecureRandomSaltProviderConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(SecureRandomSaltProvider.class);

    @Activate
    private void activate(SecureRandomSaltProviderConfiguration configuration) throws NoSuchAlgorithmException {
        this.logger.debug("activating");
        this.configuration = configuration;
        this.secureRandom = SecureRandom.getInstance(configuration.algorithm());
    }

    @Modified
    private void modified(SecureRandomSaltProviderConfiguration configuration) throws NoSuchAlgorithmException {
        this.logger.debug("modifying");
        this.configuration = configuration;
        this.secureRandom = SecureRandom.getInstance(configuration.algorithm());
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
    }

    @Override
    public byte @NotNull [] getSalt() {
        SecureRandomSaltProviderConfiguration configuration = this.configuration;
        Objects.requireNonNull(configuration, "Configuration must not be null");
        byte[] bytes = new byte[configuration.keyLength()];
        this.secureRandom.nextBytes(bytes);
        return bytes;
    }
}

