/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReferenceOperation {
    private static final Logger log = LoggerFactory.getLogger(ReferenceOperation.class);
    private Pattern regex = null;
    private Resource resource = null;

    protected ReferenceOperation(Resource resource) {
        String path = resource.getPath();
        this.regex = "sling:Page".equals(resource.getResourceType()) ? Pattern.compile("(^\\Q" + path + "\\E($|\\/)|(\\'|\\\")\\Q" + path + "\\E(\\.html|\\'|\\\"|\\/))") : Pattern.compile("(^\\Q" + path + "\\E($|\\/)|(\\'|\\\")\\Q" + path + "\\E(\\'|\\\"|\\/))");
        this.resource = resource;
    }

    private void checkReferences(Resource resource) {
        log.debug("Checking for references in resource {}", (Object)resource);
        ValueMap properties = resource.getValueMap();
        properties.keySet().forEach(k -> {
            block3: {
                block2: {
                    if (!(properties.get(k) instanceof String)) break block2;
                    if (!this.matches((String)properties.get(k, String.class))) break block3;
                    log.trace("Found reference in property {}@{}", (Object)resource.getPath(), k);
                    this.doProcess(resource, (String)k);
                    break block3;
                }
                if (properties.get(k) instanceof String[]) {
                    for (String v : (String[])properties.get(k, String[].class)) {
                        if (!this.matches(v)) continue;
                        log.trace("Found reference in property {}@{}", (Object)resource.getPath(), k);
                        this.doProcess(resource, (String)k);
                        break;
                    }
                }
            }
        });
    }

    public abstract void doProcess(Resource var1, String var2);

    public Pattern getRegex() {
        return this.regex;
    }

    public void init() {
        log.debug("Finding references to {}", (Object)this.resource.getPath());
        String query = "SELECT * FROM [nt:base] AS s WHERE NOT ISDESCENDANTNODE([/jcr:system/jcr:versionStorage]) AND CONTAINS(s.*, '" + Text.escapeIllegalXpathSearchChars((String)this.resource.getPath()) + "')";
        HashSet<String> paths = new HashSet<String>();
        Iterator resources = this.resource.getResourceResolver().findResources(query, "JCR-SQL2");
        log.debug("Checking for references with: {}", (Object)query);
        while (resources.hasNext()) {
            Resource r = (Resource)resources.next();
            if (paths.contains(r.getPath())) continue;
            this.checkReferences(r);
            paths.add(r.getPath());
        }
    }

    private boolean matches(String value) {
        Matcher matcher = this.regex.matcher(value);
        return matcher.find();
    }
}

