/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.insights.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.sling.cms.core.insights.impl.FakeHttpSession;

public class FakeRequest
implements HttpServletRequest {
    private final Map<String, Object> attributes;
    private final String method;
    private final Map<String, Object> parameters;
    private final String path;
    private final HttpSession session;

    public FakeRequest(String method, String path) {
        this.method = method;
        this.path = path;
        this.attributes = new HashMap<String, Object>();
        this.parameters = new HashMap<String, Object>();
        this.session = new FakeHttpSession();
    }

    public FakeRequest(String method, String path, Map<String, Object> params) {
        this.method = method;
        this.path = path;
        this.attributes = new HashMap<String, Object>();
        this.parameters = new HashMap<String, Object>();
        this.session = new FakeHttpSession();
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (params.get(key) instanceof String[]) {
                this.parameters.put(key, (String[])value);
                continue;
            }
            this.parameters.put(key, new String[]{value.toString()});
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<?> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getAuthType() {
        return null;
    }

    public String getCharacterEncoding() {
        return "utf-8";
    }

    public int getContentLength() {
        return 0;
    }

    public String getContentType() {
        return null;
    }

    public String getContextPath() {
        return "";
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String name) {
        return -1L;
    }

    public String getHeader(String name) {
        return null;
    }

    public Enumeration<?> getHeaderNames() {
        return null;
    }

    public Enumeration<?> getHeaders(String name) {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public int getIntHeader(String name) {
        return -1;
    }

    public String getLocalAddr() {
        return null;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Enumeration<?> getLocales() {
        return Collections.enumeration(Collections.singleton(Locale.getDefault()));
    }

    public String getLocalName() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getMethod() {
        return this.method;
    }

    public String getParameter(String name) {
        Object value;
        try {
            value = this.parameters.get(name);
            if (value instanceof String[]) {
                return ((String[])value)[0];
            }
        }
        catch (ClassCastException e) {
            return null;
        }
        return (String)value;
    }

    public Map<String, Object> getParameterMap() {
        return this.parameters;
    }

    public Enumeration<?> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        throw new UnsupportedOperationException();
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getQueryString() {
        return null;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getRemoteUser() {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return this.path;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer("http://localhost:8080" + this.path);
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public String getServletPath() {
        return this.getRequestURI();
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpSession getSession(boolean create) {
        return this.session;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
    }
}

