/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.saml2.sp;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.PreAuthenticatedLogin;
import org.apache.sling.auth.saml2.impl.Saml2Credentials;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Saml2LoginModule.class}, immediate=true)
public class Saml2LoginModule
extends AbstractLoginModule {
    static Set<Class> SUPPORTED_CREDENTIALS = new HashSet<Class>();
    private final Logger logger = LoggerFactory.getLogger(Saml2LoginModule.class);

    @Nonnull
    protected Set<Class> getSupportedCredentials() {
        return SUPPORTED_CREDENTIALS;
    }

    public boolean login() throws LoginException {
        Credentials credentials = this.getCredentials();
        if (credentials instanceof Saml2Credentials) {
            String userId = ((Saml2Credentials)credentials).getUserId();
            if (userId == null) {
                this.logger.warn("Could not extract userId from credentials");
            } else {
                this.sharedState.put(SHARED_KEY_PRE_AUTH_LOGIN, new PreAuthenticatedLogin(userId));
                this.sharedState.put("org.apache.jackrabbit.credentials", new SimpleCredentials(userId, new char[0]));
                this.sharedState.put("javax.security.auth.login.name", userId);
                this.logger.debug("Adding pre-authenticated login user '{}' to shared state.", (Object)userId);
            }
        }
        return false;
    }

    public boolean commit() throws LoginException {
        return false;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.logger.debug("initialize called");
    }

    public boolean abort() throws LoginException {
        this.logger.info("abort() called");
        return super.abort();
    }

    protected void clearState() {
        this.logger.info("clearState() called");
        super.clearState();
    }

    static {
        SUPPORTED_CREDENTIALS.add(Saml2Credentials.class);
    }
}

