/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers.impl;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.sling.api.wrappers.impl.JcrRules;
import org.osgi.util.converter.ConversionException;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.ConverterBuilder;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.TargetRule;
import org.osgi.util.converter.TypeRule;

public final class ObjectConverter {
    private ObjectConverter() {
    }

    private static String toString(ZonedDateTime zonedDateTime) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime);
    }

    private static Calendar toCalendar(ZonedDateTime zonedDateTime) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(zonedDateTime.getOffset()));
        calendar.setTimeInMillis(zonedDateTime.toInstant().toEpochMilli());
        return calendar;
    }

    private static ZonedDateTime toZonedDateTime(Calendar calendar) {
        return ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId().normalized());
    }

    private static String toString(Calendar cal) {
        return cal.toInstant().toString();
    }

    private static String toString(Date cal) {
        return cal.toInstant().toString();
    }

    private static Calendar toCalendar(String date) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(date, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        return ObjectConverter.toCalendar(zonedDateTime);
    }

    private static Calendar toCalendar(Date date) {
        Calendar response = Calendar.getInstance();
        response.setTime(date);
        return response;
    }

    private static Date toDate(String date) {
        return Date.from(Instant.parse(date));
    }

    private static Date toDate(Calendar cal) {
        return cal.getTime();
    }

    public static <T> T convert(Object obj, Class<T> type) {
        if (obj == null) {
            return null;
        }
        try {
            return (T)ConverterHolder.CONVERTER.convert(obj).to(type);
        }
        catch (ConversionException ce) {
            return null;
        }
    }

    private static class ConverterHolder {
        private static final Converter CONVERTER;

        private ConverterHolder() {
        }

        static {
            ConverterBuilder converterBuilder = Converters.newConverterBuilder().rule((TargetRule)new TypeRule(String.class, Calendar.class, x$0 -> ObjectConverter.toCalendar(x$0))).rule((TargetRule)new TypeRule(Date.class, Calendar.class, x$0 -> ObjectConverter.toCalendar(x$0))).rule((TargetRule)new TypeRule(String.class, Date.class, x$0 -> ObjectConverter.toDate(x$0))).rule((TargetRule)new TypeRule(Calendar.class, String.class, x$0 -> ObjectConverter.toString(x$0))).rule((TargetRule)new TypeRule(Date.class, String.class, x$0 -> ObjectConverter.toString(x$0))).rule((TargetRule)new TypeRule(Calendar.class, Date.class, x$0 -> ObjectConverter.toDate(x$0))).rule((TargetRule)new TypeRule(Calendar.class, ZonedDateTime.class, x$0 -> ObjectConverter.toZonedDateTime(x$0))).rule((TargetRule)new TypeRule(ZonedDateTime.class, Calendar.class, x$0 -> ObjectConverter.toCalendar(x$0))).rule((TargetRule)new TypeRule(ZonedDateTime.class, String.class, x$0 -> ObjectConverter.toString(x$0)));
            try {
                JcrRules.addJcrRules(converterBuilder);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            CONVERTER = converterBuilder.build();
        }
    }
}

