/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.feature.launcher;

import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.sling.maven.feature.launcher.LauncherArguments;

public class Launch {
    private static final Pattern ID_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-\\.]+");
    private String id;
    private Dependency feature;
    private LauncherArguments launcherArguments;
    private int startTimeoutSeconds = 30;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Dependency getFeature() {
        return this.feature;
    }

    public void setFeature(Dependency feature) {
        this.feature = feature;
    }

    public LauncherArguments getLauncherArguments() {
        return this.launcherArguments;
    }

    public void setLauncherArguments(LauncherArguments launcherArguments) {
        this.launcherArguments = launcherArguments;
    }

    public int getStartTimeoutSeconds() {
        return this.startTimeoutSeconds;
    }

    public void setStartTimeoutSeconds(int startTimeoutSeconds) {
        this.startTimeoutSeconds = startTimeoutSeconds;
    }

    public void validate() {
        if (this.id == null || this.id.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing id");
        }
        if (!ID_PATTERN.matcher(this.id).matches()) {
            throw new IllegalArgumentException("Invalid id '" + this.id + "'. Allowed characters are digits, numbers, '-','_' and '.'.");
        }
        if (this.startTimeoutSeconds < 0) {
            this.throwInvalid("startTimeout value '" + this.startTimeoutSeconds + "' is negative");
        }
        if (this.feature == null) {
            this.throwInvalid("required field 'feature' is missing");
        }
        if (!"slingosgifeature".equals(this.feature.getType())) {
            this.throwInvalid("type must be 'slingosgifeature' but is '" + this.feature.getType() + "'");
        }
    }

    private void throwInvalid(String reason) {
        throw new IllegalArgumentException("Invalid launch '" + this.id + "': " + reason);
    }
}

