/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.awt.Point;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.coverage.j2d.RasterFactory;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.TiledGridResource;
import org.apache.sis.internal.storage.inflater.Inflater;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.geotiff.DataCube;
import org.apache.sis.storage.geotiff.DataSubset;

final class CompressedSubset
extends DataSubset {
    private final long scanlineStride;
    private final int beforeFirstBand;
    private final int afterLastBand;
    private final int[] skipAfterChunks;
    private final int samplesPerChunk;
    private transient Inflater inflater;

    CompressedSubset(DataCube dataCube, TiledGridResource.Subset subset) throws DataStoreException {
        super(dataCube, subset);
        this.scanlineStride = JDK9.multiplyFull((int)this.getTileSize(0), (int)this.sourcePixelStride);
        int n = this.sourcePixelStride * (this.getSubsampling(0) - 1);
        int n2 = this.sourcePixelStride * (this.getTileSize(0) - 1);
        if (this.includedBands != null && this.sourcePixelStride > 1) {
            int[] nArray = new int[this.includedBands.length];
            int n3 = nArray.length - 1;
            int n4 = this.sourcePixelStride;
            for (int i = n3; i >= 0; --i) {
                int n5 = n4;
                n4 = this.includedBands[i];
                nArray[i] = n5 - n4 - 1;
            }
            this.beforeFirstBand = n4;
            n2 += nArray[n3];
            int n6 = n3;
            nArray[n6] = nArray[n6] + (n + this.beforeFirstBand);
            if (n3 != 0 && CompressedSubset.startsWithZeros(nArray, n3)) {
                this.samplesPerChunk = this.includedBands.length;
                this.skipAfterChunks = new int[]{nArray[n3]};
            } else {
                this.samplesPerChunk = 1;
                this.skipAfterChunks = nArray;
            }
        } else {
            int[] nArray;
            if (n != 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = n;
            } else {
                nArray = null;
            }
            this.skipAfterChunks = nArray;
            this.samplesPerChunk = this.sourcePixelStride;
            this.beforeFirstBand = 0;
        }
        this.afterLastBand = n2;
        assert (this.targetPixelStride % this.samplesPerChunk == 0) : this.samplesPerChunk;
    }

    private static boolean startsWithZeros(int[] nArray, int n) {
        do {
            if (nArray[--n] == 0) continue;
            return false;
        } while (n != 0);
        return true;
    }

    private static int pixelCount(long[] lArray, long[] lArray2, int[] nArray, int n) {
        int n2 = Math.toIntExact((lArray2[n] - lArray[n] - 1L) / (long)nArray[n] + 1L);
        assert (n2 > 0) : n2;
        return n2;
    }

    @Override
    WritableRaster readSlice(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, int[] nArray, Point point) throws IOException, DataStoreException {
        DataType dataType = this.getDataType();
        int n = CompressedSubset.pixelCount(lArray3, lArray4, nArray, 0);
        int n2 = CompressedSubset.pixelCount(lArray3, lArray4, nArray, 1);
        int n3 = n * (this.targetPixelStride / this.samplesPerChunk);
        int n4 = nArray[1] - 1;
        long l = (long)this.beforeFirstBand + (long)this.sourcePixelStride * lArray3[0];
        long l2 = (long)this.afterLastBand - (long)this.sourcePixelStride * (lArray3[0] + (long)((n - 1) * nArray[0]));
        int n5 = this.getPixelsPerElement();
        assert (l % (long)n5 == 0L) : l;
        if (this.inflater == null) {
            this.inflater = Inflater.create(this, this.input(), this.source.getCompression(), this.source.getPredictor(), this.sourcePixelStride, this.getTileSize(0), n3, this.samplesPerChunk, this.skipAfterChunks, n5, dataType);
        }
        Inflater inflater = this.inflater;
        int n6 = this.getBankCapacity(n5);
        Buffer[] bufferArray = new Buffer[this.numBanks];
        for (int i = 0; i < this.numBanks; ++i) {
            Buffer buffer = RasterFactory.createBuffer(dataType, n6);
            inflater.setInputOutput(lArray[i], lArray2[i], buffer);
            long l3 = lArray3[1];
            while (--l3 >= 0L) {
                inflater.skip(this.scanlineStride);
            }
            int n7 = n2;
            while (--n7 > 0) {
                inflater.skip(l);
                inflater.uncompressRow();
                inflater.skip(l2);
                int n8 = n4;
                while (--n8 >= 0) {
                    inflater.skip(this.scanlineStride);
                }
            }
            inflater.skip(l);
            inflater.uncompressRow();
            this.fillRemainingRows(buffer.flip());
            bufferArray[i] = buffer;
        }
        return WritableRaster.createWritableRaster(this.model, RasterFactory.wrap(dataType, bufferArray), point);
    }

    @Override
    final Closeable createInflater() {
        assert (this.inflater == null);
        return this::releaseInflater;
    }

    private void releaseInflater() throws IOException {
        assert (Thread.holdsLock(this.source.getSynchronizationLock()));
        Inflater inflater = this.inflater;
        if (inflater != null) {
            this.inflater = null;
            inflater.close();
        }
    }
}

