/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.sis.internal.storage.inflater.CompressionChannel;
import org.apache.sis.internal.storage.io.ChannelDataInput;

final class ZIP
extends CompressionChannel {
    private final Inflater inflater = new Inflater();

    public ZIP(ChannelDataInput channelDataInput) {
        super(channelDataInput);
    }

    @Override
    public void setInput(long l, long l2) throws IOException {
        super.setInput(l, l2);
        this.inflater.reset();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        int n2 = 0;
        try {
            int n3;
            while ((n3 = this.inflate(byteBuffer)) == 0) {
                if (this.inflater.needsInput()) {
                    if (++n2 >= this.input.buffer.capacity()) {
                        throw new BufferOverflowException();
                    }
                    this.input.ensureBufferContains(n2);
                    this.setInput(this.input.buffer);
                    continue;
                }
                if (this.inflater.finished()) {
                    return -1;
                }
                throw new IOException();
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException(dataFormatException);
        }
        return byteBuffer.position() - n;
    }

    private int inflate(ByteBuffer byteBuffer) throws DataFormatException {
        int n = byteBuffer.position();
        int n2 = this.inflater.inflate(byteBuffer.array(), n, byteBuffer.remaining());
        byteBuffer.position(n + n2);
        return n2;
    }

    private void setInput(ByteBuffer byteBuffer) throws DataFormatException {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        this.inflater.setInput(byArray);
    }

    @Override
    public void close() {
        this.inflater.end();
        super.close();
    }
}

