/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.internal.storage.inflater.CompressionChannel;
import org.apache.sis.internal.storage.io.ChannelDataInput;

final class PackBits
extends CompressionChannel {
    private int literalCount;
    private int duplicatedCount;
    private byte duplicated;

    public PackBits(ChannelDataInput channelDataInput) {
        super(channelDataInput);
    }

    @Override
    public void setInput(long l, long l2) throws IOException {
        super.setInput(l, l2);
        this.literalCount = 0;
        this.duplicatedCount = 0;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        ByteBuffer byteBuffer2 = this.input.buffer;
        while (byteBuffer.hasRemaining()) {
            int n2;
            int n3;
            if ((this.literalCount | this.duplicatedCount) == 0) {
                do {
                    if (!this.finished()) continue;
                    n2 = byteBuffer.position() - n;
                    return n2 > 0 ? n2 : -1;
                } while ((n3 = this.input.readByte()) == -128);
                if (n3 >= 0) {
                    this.literalCount = n3 + 1;
                } else {
                    this.duplicatedCount = 1 - n3;
                    this.duplicated = this.input.readByte();
                }
            }
            if (this.literalCount != 0) {
                n3 = Math.min(this.literalCount, byteBuffer.remaining());
                n2 = byteBuffer2.remaining();
                if (n2 == 0) {
                    this.input.ensureBufferContains(Math.min(n3, byteBuffer2.capacity()));
                    n2 = byteBuffer2.remaining();
                }
                if (n2 <= n3) {
                    byteBuffer.put(byteBuffer2);
                    n3 = n2;
                } else {
                    int n4 = byteBuffer2.limit();
                    byteBuffer2.limit(byteBuffer2.position() + n3);
                    byteBuffer.put(byteBuffer2);
                    byteBuffer2.limit(n4);
                }
                this.literalCount -= n3;
                continue;
            }
            n3 = Math.min(this.duplicatedCount, byteBuffer.remaining());
            PackBits.repeat(byteBuffer, this.duplicated, n3);
            this.duplicatedCount -= n3;
        }
        return byteBuffer.position() - n;
    }
}

