/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.storage.inflater.Inflater;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.storage.UnsupportedEncodingException;
import org.apache.sis.util.resources.Errors;

abstract class CopyFromBytes
extends Inflater {
    private long streamPosition;
    private boolean positionNeedsRefresh;
    private final int bytesPerElement;
    private final int pixelsPerElement;

    private CopyFromBytes(ChannelDataInput channelDataInput, int n, int n2, int[] nArray, int n3, int n4) {
        super(channelDataInput, n, n2, nArray, n3, channelDataInput.buffer.capacity() / n4);
        this.bytesPerElement = n4;
        this.pixelsPerElement = n3;
    }

    static CopyFromBytes create(ChannelDataInput channelDataInput, DataType dataType, int n, int n2, int[] nArray, int n3) throws UnsupportedEncodingException {
        switch (dataType) {
            case USHORT: 
            case SHORT: {
                return new Shorts(channelDataInput, n, n2, nArray, n3);
            }
            case BYTE: {
                return new Bytes(channelDataInput, n, n2, nArray, n3);
            }
            case INT: {
                return new Ints(channelDataInput, n, n2, nArray, n3);
            }
            case FLOAT: {
                return new Floats(channelDataInput, n, n2, nArray, n3);
            }
            case DOUBLE: {
                return new Doubles(channelDataInput, n, n2, nArray, n3);
            }
        }
        throw new UnsupportedEncodingException(Errors.format((short)163, (Object)((Object)dataType)));
    }

    @Override
    public void setInputOutput(long l, long l2, Buffer buffer) throws IOException {
        super.setInputOutput(l, l2, buffer);
        this.streamPosition = l;
        this.positionNeedsRefresh = false;
    }

    @Override
    public void uncompressRow() throws IOException {
        if (!this.positionNeedsRefresh) {
            this.positionNeedsRefresh = true;
            this.input.seek(this.streamPosition);
        }
    }

    @Override
    public final void skip(long l) throws IOException {
        if (l != 0L) {
            if (this.positionNeedsRefresh) {
                this.positionNeedsRefresh = false;
                this.streamPosition = this.input.getStreamPosition();
            }
            boolean bl = l % (long)this.pixelsPerElement > 0L;
            l /= (long)this.pixelsPerElement;
            if (bl) {
                ++l;
            }
            this.streamPosition = Math.addExact(this.streamPosition, l *= (long)this.bytesPerElement);
        }
    }

    final int skipAfterChunk(int n) throws IOException {
        int n2 = this.skipAfterChunks[n] * this.bytesPerElement;
        while (n2 != 0) {
            int n3 = this.input.buffer.position();
            int n4 = Math.min(n3 + n2, this.input.buffer.limit());
            this.input.buffer.position(n4);
            if ((n2 -= n4 - n3) == 0) break;
            this.input.ensureBufferContains(this.bytesPerElement);
        }
        return ++n < this.skipAfterChunks.length ? n : 0;
    }

    private static final class Shorts
    extends CopyFromBytes {
        private ShortBuffer bank;

        Shorts(ChannelDataInput channelDataInput, int n, int n2, int[] nArray, int n3) {
            super(channelDataInput, n, n2, nArray, n3, 2);
        }

        @Override
        public void setInputOutput(long l, long l2, Buffer buffer) throws IOException {
            super.setInputOutput(l, l2, buffer);
            this.bank = (ShortBuffer)buffer;
        }

        @Override
        public void uncompressRow() throws IOException {
            super.uncompressRow();
            int n = 0;
            ByteBuffer byteBuffer = this.input.buffer;
            int n2 = this.chunksPerRow;
            while (--n2 > 0) {
                int n3 = this.elementsPerChunk;
                this.input.ensureBufferContains(n3 * 2);
                do {
                    this.bank.put(byteBuffer.getShort());
                } while (--n3 != 0);
                if (this.skipAfterChunks == null) continue;
                n = this.skipAfterChunk(n);
            }
            n2 = this.elementsPerChunk * 2;
            this.input.ensureBufferContains(n2);
            this.bank.put((ShortBuffer)byteBuffer.asShortBuffer().limit(this.elementsPerChunk));
            byteBuffer.position(byteBuffer.position() + n2);
        }
    }

    private static final class Bytes
    extends CopyFromBytes {
        private ByteBuffer bank;

        Bytes(ChannelDataInput channelDataInput, int n, int n2, int[] nArray, int n3) {
            super(channelDataInput, n, n2, nArray, n3, 1);
        }

        @Override
        public void setInputOutput(long l, long l2, Buffer buffer) throws IOException {
            super.setInputOutput(l, l2, buffer);
            this.bank = (ByteBuffer)buffer;
        }

        @Override
        public void uncompressRow() throws IOException {
            super.uncompressRow();
            int n = 0;
            ByteBuffer byteBuffer = this.input.buffer;
            int n2 = this.chunksPerRow;
            while (--n2 > 0) {
                int n3 = this.elementsPerChunk;
                this.input.ensureBufferContains(n3);
                do {
                    this.bank.put(byteBuffer.get());
                } while (--n3 != 0);
                if (this.skipAfterChunks == null) continue;
                n = this.skipAfterChunk(n);
            }
            this.input.ensureBufferContains(this.elementsPerChunk);
            n2 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + this.elementsPerChunk);
            this.bank.put(byteBuffer);
            byteBuffer.limit(n2);
        }
    }

    private static final class Ints
    extends CopyFromBytes {
        private IntBuffer bank;

        Ints(ChannelDataInput channelDataInput, int n, int n2, int[] nArray, int n3) {
            super(channelDataInput, n, n2, nArray, n3, 4);
        }

        @Override
        public void setInputOutput(long l, long l2, Buffer buffer) throws IOException {
            super.setInputOutput(l, l2, buffer);
            this.bank = (IntBuffer)buffer;
        }

        @Override
        public void uncompressRow() throws IOException {
            super.uncompressRow();
            int n = 0;
            ByteBuffer byteBuffer = this.input.buffer;
            int n2 = this.chunksPerRow;
            while (--n2 > 0) {
                int n3 = this.elementsPerChunk;
                this.input.ensureBufferContains(n3 * 4);
                do {
                    this.bank.put(byteBuffer.getInt());
                } while (--n3 != 0);
                if (this.skipAfterChunks == null) continue;
                n = this.skipAfterChunk(n);
            }
            n2 = this.elementsPerChunk * 4;
            this.input.ensureBufferContains(n2);
            this.bank.put((IntBuffer)byteBuffer.asIntBuffer().limit(this.elementsPerChunk));
            byteBuffer.position(byteBuffer.position() + n2);
        }
    }

    private static final class Floats
    extends CopyFromBytes {
        private FloatBuffer bank;

        Floats(ChannelDataInput channelDataInput, int n, int n2, int[] nArray, int n3) {
            super(channelDataInput, n, n2, nArray, n3, 4);
        }

        @Override
        public void setInputOutput(long l, long l2, Buffer buffer) throws IOException {
            super.setInputOutput(l, l2, buffer);
            this.bank = (FloatBuffer)buffer;
        }

        @Override
        public void uncompressRow() throws IOException {
            super.uncompressRow();
            int n = 0;
            ByteBuffer byteBuffer = this.input.buffer;
            int n2 = this.chunksPerRow;
            while (--n2 > 0) {
                int n3 = this.elementsPerChunk;
                this.input.ensureBufferContains(n3 * 4);
                do {
                    this.bank.put(byteBuffer.getFloat());
                } while (--n3 != 0);
                if (this.skipAfterChunks == null) continue;
                n = this.skipAfterChunk(n);
            }
            n2 = this.elementsPerChunk * 4;
            this.input.ensureBufferContains(n2);
            this.bank.put((FloatBuffer)byteBuffer.asFloatBuffer().limit(this.elementsPerChunk));
            byteBuffer.position(byteBuffer.position() + n2);
        }
    }

    private static final class Doubles
    extends CopyFromBytes {
        private DoubleBuffer bank;

        Doubles(ChannelDataInput channelDataInput, int n, int n2, int[] nArray, int n3) {
            super(channelDataInput, n, n2, nArray, n3, 8);
        }

        @Override
        public void setInputOutput(long l, long l2, Buffer buffer) throws IOException {
            super.setInputOutput(l, l2, buffer);
            this.bank = (DoubleBuffer)buffer;
        }

        @Override
        public void uncompressRow() throws IOException {
            super.uncompressRow();
            int n = 0;
            ByteBuffer byteBuffer = this.input.buffer;
            int n2 = this.chunksPerRow;
            while (--n2 > 0) {
                int n3 = this.elementsPerChunk;
                this.input.ensureBufferContains(n3 * 8);
                do {
                    this.bank.put(byteBuffer.getDouble());
                } while (--n3 != 0);
                if (this.skipAfterChunks == null) continue;
                n = this.skipAfterChunk(n);
            }
            n2 = this.elementsPerChunk * 8;
            this.input.ensureBufferContains(n2);
            this.bank.put((DoubleBuffer)byteBuffer.asDoubleBuffer().limit(this.elementsPerChunk));
            byteBuffer.position(byteBuffer.position() + n2);
        }
    }
}

