/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml.stream;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import org.apache.sis.internal.storage.xml.stream.StaxDataStore;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

enum InputType {
    STAX((Class)XMLStreamReader.class){

        @Override
        XMLStreamReader create(StaxDataStore staxDataStore, Object object) {
            return (XMLStreamReader)object;
        }
    }
    ,
    STREAM((Class)InputStream.class){

        @Override
        XMLStreamReader create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            XMLInputFactory xMLInputFactory = staxDataStore.inputFactory();
            return staxDataStore.encoding != null ? xMLInputFactory.createXMLStreamReader((InputStream)object, staxDataStore.encoding.name()) : xMLInputFactory.createXMLStreamReader((InputStream)object);
        }
    }
    ,
    CHARACTERS((Class)Reader.class){

        @Override
        XMLStreamReader create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            return staxDataStore.inputFactory().createXMLStreamReader((Reader)object);
        }
    }
    ,
    SOURCE((Class)Source.class){

        @Override
        XMLStreamReader create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            return staxDataStore.inputFactory().createXMLStreamReader((Source)object);
        }
    }
    ,
    NODE((Class)Node.class){

        @Override
        XMLStreamReader create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            return staxDataStore.inputFactory().createXMLStreamReader(new DOMSource((Node)object));
        }
    }
    ,
    SAX((Class)InputSource.class){

        @Override
        XMLStreamReader create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            return staxDataStore.inputFactory().createXMLStreamReader(new SAXSource((InputSource)object));
        }
    }
    ,
    EVENT((Class)XMLEventReader.class){

        @Override
        XMLStreamReader create(StaxDataStore staxDataStore, Object object) throws XMLStreamException {
            return staxDataStore.inputFactory().createXMLStreamReader(new StAXSource((XMLEventReader)object));
        }
    };

    private final Class<?> inputType;

    private InputType(Class<?> clazz) {
        this.inputType = clazz;
    }

    abstract XMLStreamReader create(StaxDataStore var1, Object var2) throws XMLStreamException;

    static InputType forType(Class<?> clazz) {
        for (InputType inputType : InputType.values()) {
            if (!inputType.inputType.isAssignableFrom(clazz)) continue;
            return inputType;
        }
        return null;
    }
}

