/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.gpx.Metadata;
import org.apache.sis.internal.storage.gpx.Reader;
import org.apache.sis.internal.storage.gpx.StoreProvider;
import org.apache.sis.internal.storage.gpx.Types;
import org.apache.sis.internal.storage.gpx.Writer;
import org.apache.sis.internal.storage.xml.stream.StaxDataStore;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.distribution.DefaultFormat;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.Format;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

public final class Store
extends StaxDataStore
implements FeatureSet {
    Version version;
    private org.opengis.metadata.Metadata metadata;
    private Reader reader;
    final Types types;

    public Store(StoreProvider storeProvider, StorageConnector storageConnector) throws DataStoreException {
        super(storeProvider, storageConnector);
        GeometryLibrary geometryLibrary = (GeometryLibrary)((Object)storageConnector.getOption(OptionKey.GEOMETRY_LIBRARY));
        if (geometryLibrary == null || Types.DEFAULT.geometries.library == geometryLibrary) {
            this.types = Types.DEFAULT;
        } else {
            try {
                this.types = new Types((NameFactory)DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class), null, geometryLibrary);
            }
            catch (FactoryException factoryException) {
                throw new DataStoreException((Throwable)factoryException);
            }
        }
    }

    final Format getFormat() {
        assert (Thread.holdsLock((Object)this));
        Format format = ((StoreProvider)this.provider).getFormat(this.listeners);
        if (this.version != null) {
            DefaultFormat defaultFormat = new DefaultFormat(format);
            DefaultCitation defaultCitation = new DefaultCitation(defaultFormat.getFormatSpecificationCitation());
            defaultCitation.setEdition((InternationalString)new SimpleInternationalString(this.version.toString()));
            defaultFormat.setFormatSpecificationCitation((Citation)defaultCitation);
            format = defaultFormat;
        }
        return format;
    }

    public synchronized Version getVersion() throws DataStoreException {
        if (this.version == null) {
            this.getMetadata();
        }
        return this.version;
    }

    public synchronized void setVersion(Version version) throws DataStoreException {
        ArgumentChecks.ensureNonNull("version", version);
        this.version = version;
    }

    public synchronized org.opengis.metadata.Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            try {
                this.reader = new Reader(this);
                this.version = this.reader.initialize(true);
                this.metadata = this.reader.getMetadata();
            }
            catch (DataStoreException dataStoreException) {
                throw dataStoreException;
            }
            catch (RuntimeException | URISyntaxException exception) {
                throw new DataStoreContentException((Throwable)exception);
            }
            catch (Exception exception) {
                throw new DataStoreException((Throwable)exception);
            }
        }
        return this.metadata;
    }

    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.ofNullable(StoreUtilities.getEnvelope((org.opengis.metadata.Metadata)this.getMetadata()));
    }

    public DefaultFeatureType getType() {
        return this.types.parent;
    }

    @Deprecated
    public DefaultFeatureType getFeatureType(String string) throws IllegalNameException {
        return (DefaultFeatureType)this.types.names.get((DataStore)this, string);
    }

    public final synchronized Stream<AbstractFeature> features(boolean bl) throws DataStoreException {
        Reader reader = this.reader;
        this.reader = null;
        if (reader == null) {
            try {
                reader = new Reader(this);
                this.version = reader.initialize(false);
            }
            catch (DataStoreException dataStoreException) {
                throw dataStoreException;
            }
            catch (RuntimeException | URISyntaxException exception) {
                throw new DataStoreContentException((Throwable)exception);
            }
            catch (Exception exception) {
                throw new DataStoreException((Throwable)exception);
            }
        }
        Stream<AbstractFeature> stream = StreamSupport.stream(reader, false);
        return (Stream)stream.onClose(reader);
    }

    public synchronized void write(org.opengis.metadata.Metadata metadata, Stream<? extends AbstractFeature> stream) throws DataStoreException {
        try {
            Reader reader = this.reader;
            if (reader != null) {
                this.reader = null;
                reader.close();
            }
            try (Writer writer = new Writer(this, Metadata.castOrCopy(metadata, this.locale));){
                writer.writeStartDocument();
                if (stream != null) {
                    stream.forEachOrdered(writer);
                }
                writer.writeEndDocument();
            }
        }
        catch (BackingStoreException backingStoreException) {
            Throwable throwable = backingStoreException.getCause();
            if (throwable instanceof DataStoreException) {
                throw (DataStoreException)throwable;
            }
            throw new DataStoreException(backingStoreException.getLocalizedMessage(), throwable);
        }
        catch (Exception exception) {
            IOException iOException;
            if (exception instanceof UncheckedIOException) {
                iOException = ((UncheckedIOException)exception).getCause();
            }
            throw new DataStoreException((Throwable)iOException);
        }
    }

    @Override
    public synchronized void close() throws DataStoreException {
        Reader reader = this.reader;
        this.reader = null;
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                DataStoreException dataStoreException = new DataStoreException((Throwable)exception);
                try {
                    super.close();
                }
                catch (DataStoreException dataStoreException2) {
                    dataStoreException.addSuppressed(dataStoreException2.getCause());
                }
                throw dataStoreException;
            }
        }
        super.close();
    }
}

