/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.storage.gpx.Email;
import org.apache.sis.internal.storage.gpx.Link;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.InternationalString;

public final class Person
implements ResponsibleParty,
Contact,
Address {
    @XmlElement(name="name")
    public String name;
    boolean isCreator;
    @XmlElement(name="email")
    @XmlJavaTypeAdapter(value=Email.class)
    public String email;
    @XmlElement(name="link")
    public Link link;

    public Person() {
    }

    Person(String string) {
        this.name = string;
        this.isCreator = true;
    }

    public static Person castOrCopy(ResponsibleParty responsibleParty, Locale locale) {
        String string;
        if (responsibleParty == null || responsibleParty instanceof Person) {
            return (Person)responsibleParty;
        }
        Role role = responsibleParty.getRole();
        boolean bl = Role.ORIGINATOR.equals((Object)role);
        if ((bl || Role.AUTHOR.equals((Object)role)) && (string = responsibleParty.getIndividualName()) != null) {
            Person person = new Person();
            person.name = string;
            person.isCreator = bl;
            return person;
        }
        return null;
    }

    public Role getRole() {
        return this.isCreator ? Role.ORIGINATOR : Role.AUTHOR;
    }

    public InternationalString getOrganisationName() {
        return null;
    }

    public InternationalString getPositionName() {
        return null;
    }

    public String getIndividualName() {
        return this.name;
    }

    public Contact getContactInfo() {
        return this.email != null || this.link != null ? this : null;
    }

    public Telephone getPhone() {
        return null;
    }

    public Address getAddress() {
        return this.email != null ? this : null;
    }

    public OnlineResource getOnlineResource() {
        return this.link;
    }

    public InternationalString getHoursOfService() {
        return null;
    }

    public InternationalString getContactInstructions() {
        return null;
    }

    public Collection<String> getDeliveryPoints() {
        return Collections.emptyList();
    }

    public InternationalString getCity() {
        return null;
    }

    public InternationalString getAdministrativeArea() {
        return null;
    }

    public String getPostalCode() {
        return null;
    }

    public InternationalString getCountry() {
        return null;
    }

    public Collection<String> getElectronicMailAddresses() {
        return this.email != null ? Collections.singleton(this.email) : Collections.emptySet();
    }

    public boolean equals(Object object) {
        if (object instanceof Person) {
            Person person = (Person)object;
            return Objects.equals(this.name, person.name) && Objects.equals(this.email, person.email) && Objects.equals(this.link, person.link);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.email, this.link);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null) {
            stringBuilder.append(this.name);
        }
        if (this.email != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('<').append(this.email).append('>');
        }
        if (this.link != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(System.lineSeparator());
            }
            stringBuilder.append(this.link);
        }
        return stringBuilder.toString();
    }
}

