/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.xml.MarshalContext;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.util.InternationalString;

public final class Link
implements OnlineResource {
    @XmlAttribute(name="href", required=true)
    public URI uri;
    @XmlElement(name="text")
    public String text;
    @XmlElement(name="type")
    public String type;

    public Link() {
    }

    public Link(URI uRI) {
        this.uri = uRI;
    }

    static Link valueOf(URI uRI) {
        return uRI != null ? new Link(uRI) : null;
    }

    final void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        if (this.uri == null && this.text != null) {
            Context context = Context.current();
            try {
                Context.converter((Context)context).toURI((MarshalContext)context, this.text);
            }
            catch (URISyntaxException uRISyntaxException) {
                Context.warningOccured((Context)context, Link.class, (String)"afterUnmarshal", (Exception)uRISyntaxException, (boolean)true);
            }
        }
    }

    private Link(OnlineResource onlineResource, Locale locale) {
        this.uri = onlineResource.getLinkage();
        this.text = onlineResource.getName();
    }

    public static Link castOrCopy(OnlineResource onlineResource, Locale locale) {
        return onlineResource == null || onlineResource instanceof Link ? (Link)onlineResource : new Link(onlineResource, locale);
    }

    public URI getLinkage() {
        return this.uri;
    }

    public String getProtocol() {
        return null;
    }

    public String getApplicationProfile() {
        return null;
    }

    public String getName() {
        return this.text;
    }

    public InternationalString getDescription() {
        return null;
    }

    public OnLineFunction getFunction() {
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof Link) {
            Link link = (Link)object;
            return Objects.equals(this.uri, link.uri) && Objects.equals(this.text, link.text) && Objects.equals(this.type, link.type);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.text, this.type);
    }

    public String toString() {
        return this.uri != null ? this.uri.toString() : null;
    }
}

