/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import javax.xml.bind.annotation.XmlAttribute;
import org.apache.sis.internal.storage.xml.GeographicEnvelope;
import org.opengis.metadata.extent.GeographicBoundingBox;

public final class Bounds
extends GeographicEnvelope {
    @XmlAttribute(name="minlon", required=true)
    public double westBoundLongitude = Double.NaN;
    @XmlAttribute(name="maxlon", required=true)
    public double eastBoundLongitude = Double.NaN;
    @XmlAttribute(name="minlat", required=true)
    public double southBoundLatitude = Double.NaN;
    @XmlAttribute(name="maxlat", required=true)
    public double northBoundLatitude = Double.NaN;

    public Bounds() {
    }

    private Bounds(GeographicBoundingBox geographicBoundingBox) {
        this.westBoundLongitude = geographicBoundingBox.getWestBoundLongitude();
        this.eastBoundLongitude = geographicBoundingBox.getEastBoundLongitude();
        this.northBoundLatitude = geographicBoundingBox.getNorthBoundLatitude();
        this.southBoundLatitude = geographicBoundingBox.getSouthBoundLatitude();
    }

    public static Bounds castOrCopy(GeographicBoundingBox geographicBoundingBox) {
        return geographicBoundingBox == null || geographicBoundingBox instanceof Bounds ? (Bounds)geographicBoundingBox : new Bounds(geographicBoundingBox);
    }

    public double getWestBoundLongitude() {
        return this.westBoundLongitude;
    }

    public double getEastBoundLongitude() {
        return this.eastBoundLongitude;
    }

    public double getSouthBoundLatitude() {
        return this.southBoundLatitude;
    }

    public double getNorthBoundLatitude() {
        return this.northBoundLatitude;
    }
}

