/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.awt.geom.AffineTransform;
import java.util.Locale;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.portrayal.Canvas;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.spatial.DimensionNameType;

public abstract class PlanarCanvas
extends Canvas {
    protected static final int BIDIMENSIONAL = 2;
    protected final AffineTransform objectiveToDisplay = new AffineTransform();

    protected PlanarCanvas(Locale locale) {
        super(CommonCRS.Engineering.DISPLAY.crs(), locale);
    }

    @Override
    final int getDisplayDimensions() {
        return 2;
    }

    @Override
    final void getDisplayAxes(DimensionNameType[] dimensionNameTypeArray) {
        dimensionNameTypeArray[0] = DimensionNameType.COLUMN;
        dimensionNameTypeArray[1] = DimensionNameType.ROW;
    }

    @Override
    final DirectPosition allocatePosition() {
        return new DirectPosition2D(super.getObjectiveCRS());
    }

    @Override
    public Envelope2D getDisplayBounds() {
        return this.displayBounds.isAllNaN() ? null : new Envelope2D(this.displayBounds);
    }

    @Override
    final LinearTransform updateObjectiveToDisplay() {
        return new AffineTransform2D(this.objectiveToDisplay);
    }

    @Override
    final void updateObjectiveToDisplay(LinearTransform linearTransform) {
        this.objectiveToDisplay.setTransform(AffineTransforms2D.castOrCopy(linearTransform.getMatrix()));
        super.updateObjectiveToDisplay(linearTransform);
    }

    public void transformObjectiveCoordinates(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            LinearTransform linearTransform = this.hasListener("objectiveToDisplay") ? this.getObjectiveToDisplay() : null;
            this.objectiveToDisplay.concatenate(affineTransform);
            this.invalidateObjectiveToDisplay(linearTransform);
        }
    }

    public void transformDisplayCoordinates(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            LinearTransform linearTransform = this.hasListener("objectiveToDisplay") ? this.getObjectiveToDisplay() : null;
            this.objectiveToDisplay.preConcatenate(affineTransform);
            this.invalidateObjectiveToDisplay(linearTransform);
        }
    }
}

