/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IncompleteGridGeometryException;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WraparoundApplicator;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.portrayal.CanvasContext;
import org.apache.sis.portrayal.CanvasExtent;
import org.apache.sis.portrayal.Observable;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class Canvas
extends Observable
implements Localized {
    public static final String OBJECTIVE_CRS_PROPERTY = "objectiveCRS";
    public static final String OBJECTIVE_TO_DISPLAY_PROPERTY = "objectiveToDisplay";
    public static final String DISPLAY_BOUNDS_PROPERTY = "displayBounds";
    public static final String POINT_OF_INTEREST_PROPERTY = "pointOfInterest";
    private static final String GRID_GEOMETRY_PROPERTY = "gridGeometry";
    private static final String GEOGRAPHIC_AREA_PROPERTY = "geographicArea";
    private static final String SPATIAL_RESOLUTION_PROPERTY = "spatialResolution";
    private CoordinateReferenceSystem objectiveCRS;
    private LinearTransform objectiveToDisplay;
    final GeneralEnvelope displayBounds;
    private GeneralDirectPosition pointOfInterest;
    private DirectPosition objectivePOI;
    private MathTransform multidimToObjective;
    private CoordinateReferenceSystem augmentedObjectiveCRS;
    private long supplementalDimensions;
    private DimensionNameType[] axisTypes;
    private GridGeometry gridGeometry;
    private final CanvasContext operationContext;
    private final DefaultCoordinateOperationFactory coordinateOperationFactory;
    private final Locale locale;

    protected Canvas(EngineeringCRS engineeringCRS, Locale locale) {
        this.locale = locale;
        ArgumentChecks.ensureNonNull("displayCRS", engineeringCRS);
        this.displayBounds = new GeneralEnvelope((CoordinateReferenceSystem)engineeringCRS);
        this.displayBounds.setToNaN();
        this.coordinateOperationFactory = CoordinateOperations.factory();
        this.operationContext = new CanvasContext();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    int getDisplayDimensions() {
        return ReferencingUtilities.getDimension((CoordinateReferenceSystem)this.getDisplayCRS());
    }

    void getDisplayAxes(DimensionNameType[] dimensionNameTypeArray) {
    }

    public final EngineeringCRS getDisplayCRS() {
        return (EngineeringCRS)this.displayBounds.getCoordinateReferenceSystem();
    }

    public CoordinateReferenceSystem getObjectiveCRS() {
        return this.objectiveCRS;
    }

    public void setObjectiveCRS(CoordinateReferenceSystem coordinateReferenceSystem, DirectPosition directPosition) throws RenderException {
        ArgumentChecks.ensureNonNull(OBJECTIVE_CRS_PROPERTY, coordinateReferenceSystem);
        ArgumentChecks.ensureDimensionMatches(OBJECTIVE_CRS_PROPERTY, this.getDisplayDimensions(), coordinateReferenceSystem);
        CoordinateReferenceSystem coordinateReferenceSystem2 = this.objectiveCRS;
        if (!coordinateReferenceSystem.equals(coordinateReferenceSystem2)) {
            try {
                CoordinateOperation coordinateOperation = this.objectiveToGeographic(coordinateReferenceSystem);
                LinearTransform linearTransform = null;
                LinearTransform linearTransform2 = null;
                if (coordinateReferenceSystem2 != null) {
                    MathTransform mathTransform = this.findTransform(coordinateReferenceSystem, coordinateReferenceSystem2, false);
                    if (this.pointOfInterest != null && !mathTransform.isIdentity()) {
                        MathTransform mathTransform2;
                        Object object;
                        CoordinateReferenceSystem coordinateReferenceSystem3 = this.pointOfInterest.getCoordinateReferenceSystem();
                        MathTransform mathTransform3 = this.findTransform(coordinateReferenceSystem3, coordinateReferenceSystem, false);
                        DirectPosition directPosition2 = mathTransform3.transform((DirectPosition)this.pointOfInterest, this.allocatePosition());
                        if (directPosition == null) {
                            directPosition = directPosition2;
                        } else {
                            object = directPosition.getCoordinateReferenceSystem();
                            ArgumentChecks.ensureNonNull("anchor.CRS", object);
                            if (!Utilities.equalsIgnoreMetadata(object, coordinateReferenceSystem)) {
                                mathTransform2 = mathTransform3;
                                if (!Utilities.equalsIgnoreMetadata(object, coordinateReferenceSystem3)) {
                                    mathTransform2 = this.findTransform((CoordinateReferenceSystem)object, coordinateReferenceSystem, true);
                                }
                                directPosition = mathTransform2.transform(directPosition, this.allocatePosition());
                            }
                        }
                        linearTransform = this.getObjectiveToDisplay();
                        object = new WraparoundApplicator(null, this.objectivePOI, coordinateReferenceSystem2.getCoordinateSystem());
                        mathTransform2 = Canvas.orthogonalTangent(((WraparoundApplicator)object).forDomainOfUse(mathTransform), directPosition.getCoordinate());
                        MathTransform mathTransform4 = MathTransforms.concatenate(mathTransform2, linearTransform);
                        linearTransform2 = MathTransforms.tangent(mathTransform4, directPosition2);
                        this.updateObjectiveToDisplay(linearTransform2);
                        this.objectivePOI = directPosition2;
                        this.multidimToObjective = mathTransform3;
                        this.augmentedObjectiveCRS = null;
                        this.axisTypes = null;
                        this.gridGeometry = null;
                    }
                }
                this.objectiveCRS = coordinateReferenceSystem;
                this.operationContext.setObjectiveToGeographic(coordinateOperation);
                this.firePropertyChange(OBJECTIVE_CRS_PROPERTY, coordinateReferenceSystem2, coordinateReferenceSystem);
                if (!Objects.equals(linearTransform, linearTransform2)) {
                    this.firePropertyChange(OBJECTIVE_TO_DISPLAY_PROPERTY, linearTransform, linearTransform2);
                }
            }
            catch (TransformException | FactoryException throwable) {
                throw new RenderException(this.errors().getString((short)15, OBJECTIVE_CRS_PROPERTY), throwable);
            }
        }
    }

    private static MathTransform orthogonalTangent(MathTransform mathTransform, double[] dArray) throws TransformException, RenderException {
        double[] dArray2 = new double[mathTransform.getTargetDimensions()];
        MatrixSIS matrixSIS = MatrixSIS.castOrCopy(MathTransforms.derivativeAndTransform(mathTransform, dArray, 0, dArray2, 0));
        MatrixSIS matrixSIS2 = matrixSIS.normalizeColumns();
        MatrixSIS matrixSIS3 = Matrices.createAffine(matrixSIS, new DirectPositionView.Double(dArray2));
        int n = matrixSIS2.getNumCol();
        DoubleDouble doubleDouble = new DoubleDouble();
        for (int i = 0; i < n; ++i) {
            doubleDouble.add(DoubleDouble.castOrCopy(matrixSIS2.getNumber(0, i)));
        }
        doubleDouble.divide(n);
        if (n == 2 && dArray2.length == 2) {
            double d = Math.max(0.0, Math.min(1.0, (Canvas.cps(matrixSIS3, 0) + Canvas.cps(matrixSIS3, 1) + 2.0) / 4.0));
            double d2 = Math.sqrt(1.0 - d);
            double d3 = Math.sqrt(d);
            for (int i = 0; i <= 1; ++i) {
                int n2 = i ^ 1;
                matrixSIS3.setElement(i, i, Math.copySign(d3, matrixSIS3.getElement(i, i)));
                matrixSIS3.setElement(i, n2, Math.copySign(d2, matrixSIS3.getElement(i, n2)));
            }
        } else {
            throw new RenderException(Errors.format((short)178, "3D"));
        }
        for (int i = 0; i < n; ++i) {
            matrixSIS3.convertBefore(i, doubleDouble, null);
            matrixSIS3.convertBefore(i, null, -dArray[i]);
        }
        return MathTransforms.linear(matrixSIS3);
    }

    private static double cps(MatrixSIS matrixSIS, int n) {
        double d = matrixSIS.getElement(n, n);
        double d2 = matrixSIS.getElement(n, n ^ 1);
        return d * d - d2 * d2;
    }

    public LinearTransform getObjectiveToDisplay() {
        if (this.objectiveToDisplay == null) {
            this.objectiveToDisplay = this.updateObjectiveToDisplay();
        }
        return this.objectiveToDisplay;
    }

    LinearTransform updateObjectiveToDisplay() {
        return MathTransforms.identity(this.getDisplayDimensions());
    }

    public void setObjectiveToDisplay(LinearTransform linearTransform) throws RenderException {
        ArgumentChecks.ensureNonNull(OBJECTIVE_TO_DISPLAY_PROPERTY, linearTransform);
        int n = this.getDisplayDimensions();
        int n2 = linearTransform.getSourceDimensions();
        if (n2 == n && (n2 = linearTransform.getTargetDimensions()) == n) {
            LinearTransform linearTransform2 = this.objectiveToDisplay;
            if (linearTransform2 == null) {
                linearTransform2 = this.updateObjectiveToDisplay();
            }
            if (!linearTransform2.equals(linearTransform)) {
                this.updateObjectiveToDisplay(linearTransform);
                this.firePropertyChange(OBJECTIVE_TO_DISPLAY_PROPERTY, linearTransform2, linearTransform);
            }
            return;
        }
        throw new MismatchedDimensionException(this.errors().getString((short)81, OBJECTIVE_TO_DISPLAY_PROPERTY, n, n2));
    }

    void updateObjectiveToDisplay(LinearTransform linearTransform) {
        this.objectiveToDisplay = linearTransform;
        this.gridGeometry = null;
        this.operationContext.clear();
    }

    final void invalidateObjectiveToDisplay(LinearTransform linearTransform) {
        this.objectiveToDisplay = null;
        this.gridGeometry = null;
        this.operationContext.clear();
        if (linearTransform != null) {
            this.firePropertyChange(OBJECTIVE_TO_DISPLAY_PROPERTY, linearTransform, this.getObjectiveToDisplay());
        }
    }

    public Envelope getDisplayBounds() {
        return this.displayBounds.isAllNaN() ? null : new GeneralEnvelope(this.displayBounds);
    }

    public void setDisplayBounds(Envelope envelope) throws RenderException {
        ArgumentChecks.ensureNonNull(DISPLAY_BOUNDS_PROPERTY, envelope);
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null && !Utilities.equalsIgnoreMetadata(this.getDisplayCRS(), coordinateReferenceSystem)) {
            throw new MismatchedReferenceSystemException(this.errors().getString((short)51, IdentifiedObjects.getDisplayName((IdentifiedObject)coordinateReferenceSystem, this.getLocale())));
        }
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(this.displayBounds);
        this.displayBounds.setEnvelope(envelope);
        this.displayBounds.setCoordinateReferenceSystem(generalEnvelope.getCoordinateReferenceSystem());
        if (this.displayBounds.isEmpty()) {
            this.displayBounds.setEnvelope(generalEnvelope);
            throw new IllegalArgumentException(this.errors().getString((short)32, DISPLAY_BOUNDS_PROPERTY));
        }
        if (!generalEnvelope.equals(this.displayBounds)) {
            this.gridGeometry = null;
            this.operationContext.partialClear(false);
            this.firePropertyChange(DISPLAY_BOUNDS_PROPERTY, generalEnvelope, envelope);
        }
    }

    public DirectPosition getPointOfInterest(boolean bl) {
        DirectPosition directPosition = bl ? this.objectivePOI : this.pointOfInterest;
        return directPosition != null ? new GeneralDirectPosition(directPosition) : null;
    }

    public void setPointOfInterest(DirectPosition directPosition) throws RenderException {
        ArgumentChecks.ensureNonNull(POINT_OF_INTEREST_PROPERTY, directPosition);
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(directPosition);
        CoordinateReferenceSystem coordinateReferenceSystem = generalDirectPosition.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem == null) {
            throw new IllegalArgumentException(this.errors().getString((short)157));
        }
        GeneralDirectPosition generalDirectPosition2 = this.pointOfInterest;
        if (!generalDirectPosition.equals(generalDirectPosition2)) {
            try {
                MathTransform mathTransform;
                if (this.objectiveCRS == null) {
                    mathTransform = CRS.getComponentAt(coordinateReferenceSystem, 0, this.getDisplayDimensions());
                    if (mathTransform == null) {
                        throw new IllegalArgumentException("Can not infer objective CRS.");
                    }
                    this.operationContext.setObjectiveToGeographic(this.objectiveToGeographic((CoordinateReferenceSystem)mathTransform));
                    this.objectiveCRS = mathTransform;
                }
                if ((mathTransform = this.multidimToObjective) == null || !Utilities.equalsIgnoreMetadata(coordinateReferenceSystem, generalDirectPosition2.getCoordinateReferenceSystem())) {
                    mathTransform = this.findTransform(coordinateReferenceSystem, this.objectiveCRS, false);
                }
                this.objectivePOI = mathTransform.transform((DirectPosition)generalDirectPosition, this.allocatePosition());
                this.pointOfInterest = generalDirectPosition;
                this.multidimToObjective = mathTransform;
                this.augmentedObjectiveCRS = null;
                this.axisTypes = null;
                this.gridGeometry = null;
                this.operationContext.partialClear(true);
                this.firePropertyChange(POINT_OF_INTEREST_PROPERTY, generalDirectPosition2, directPosition);
            }
            catch (TransformException | FactoryException throwable) {
                throw new RenderException(this.errors().getString((short)15, POINT_OF_INTEREST_PROPERTY), throwable);
            }
        }
    }

    final double[] getObjectivePOI() {
        return this.objectivePOI != null ? this.objectivePOI.getCoordinate() : null;
    }

    public GridGeometry getGridGeometry() throws RenderException {
        if (this.gridGeometry == null) {
            try {
                GridExtent gridExtent;
                LinearTransform linearTransform;
                if (this.augmentedObjectiveCRS == null) {
                    if (this.pointOfInterest != null && this.objectiveCRS != null) {
                        linearTransform = this.pointOfInterest.getCoordinateReferenceSystem();
                        gridExtent = new ArrayList(4);
                        gridExtent.add(this.objectiveCRS);
                        this.supplementalDimensions = CanvasExtent.findSupplementalDimensions((CoordinateReferenceSystem)linearTransform, this.multidimToObjective.derivative((DirectPosition)this.pointOfInterest), gridExtent);
                        this.augmentedObjectiveCRS = CRS.compound(gridExtent.toArray(new CoordinateReferenceSystem[gridExtent.size()]));
                        if (Utilities.equalsIgnoreMetadata(this.augmentedObjectiveCRS, linearTransform)) {
                            this.augmentedObjectiveCRS = linearTransform;
                        }
                    } else {
                        this.augmentedObjectiveCRS = this.objectiveCRS;
                    }
                    this.axisTypes = CanvasExtent.suggestAxisTypes(this.augmentedObjectiveCRS, this.getDisplayDimensions());
                    this.getDisplayAxes(this.axisTypes);
                }
                if (this.objectiveToDisplay == null) {
                    this.objectiveToDisplay = this.updateObjectiveToDisplay();
                }
                linearTransform = this.objectiveToDisplay.inverse();
                if (this.supplementalDimensions != 0L) {
                    linearTransform = CanvasExtent.createGridToCRS(linearTransform.getMatrix(), this.pointOfInterest, this.supplementalDimensions);
                }
                if (this.displayBounds.isEmpty()) {
                    gridExtent = null;
                } else {
                    DirectPosition directPosition = this.objectivePOI;
                    if (directPosition != null) {
                        directPosition = this.objectiveToDisplay.transform(this.objectivePOI, null);
                    }
                    gridExtent = CanvasExtent.create(this.displayBounds, directPosition, this.axisTypes, linearTransform.getSourceDimensions());
                }
                this.gridGeometry = new GridGeometry(gridExtent, PixelInCell.CELL_CORNER, (MathTransform)linearTransform, this.augmentedObjectiveCRS);
            }
            catch (TransformException | FactoryException throwable) {
                throw new RenderException(this.errors().getString((short)5, GRID_GEOMETRY_PROPERTY), throwable);
            }
        }
        return this.gridGeometry;
    }

    public void setGridGeometry(GridGeometry gridGeometry) throws RenderException {
        ArgumentChecks.ensureNonNull(GRID_GEOMETRY_PROPERTY, gridGeometry);
        if (!gridGeometry.equals((Object)this.gridGeometry)) {
            try {
                GeneralDirectPosition generalDirectPosition;
                CoordinateReferenceSystem coordinateReferenceSystem;
                GridExtent gridExtent = gridGeometry.getExtent();
                int[] nArray = gridExtent.getSubspaceDimensions(this.getDisplayDimensions());
                GeneralEnvelope generalEnvelope = new GeneralEnvelope((CoordinateReferenceSystem)this.getDisplayCRS());
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    generalEnvelope.setRange(i, gridExtent.getLow(n), Math.incrementExact(gridExtent.getHigh(n)));
                }
                MathTransform mathTransform = gridGeometry.getGridToCRS(PixelInCell.CELL_CORNER);
                if (gridGeometry.isDefined(1)) {
                    coordinateReferenceSystem = gridGeometry.getCoordinateReferenceSystem();
                    generalDirectPosition = new GeneralDirectPosition(coordinateReferenceSystem);
                } else {
                    coordinateReferenceSystem = null;
                    generalDirectPosition = new GeneralDirectPosition(mathTransform.getTargetDimensions());
                }
                mathTransform.transform(gridExtent.getPointOfInterest(), 0, generalDirectPosition.coordinates, 0, 1);
                TransformSeparator transformSeparator = new TransformSeparator(mathTransform, this.coordinateOperationFactory.getMathTransformFactory());
                transformSeparator.addSourceDimensions(nArray);
                LinearTransform linearTransform = MathTransforms.tangent(transformSeparator.separate().inverse(), generalDirectPosition);
                int[] nArray2 = transformSeparator.getTargetDimensions();
                CoordinateReferenceSystem coordinateReferenceSystem2 = CRS.reduce(coordinateReferenceSystem, nArray2);
                LinearTransform linearTransform2 = MathTransforms.linear(Matrices.createDimensionSelect(generalDirectPosition.getDimension(), nArray2));
                GeneralEnvelope generalEnvelope2 = new GeneralEnvelope(this.displayBounds);
                GeneralDirectPosition generalDirectPosition2 = this.pointOfInterest;
                LinearTransform linearTransform3 = this.objectiveToDisplay;
                CoordinateReferenceSystem coordinateReferenceSystem3 = this.objectiveCRS;
                this.displayBounds.setEnvelope(generalEnvelope);
                this.updateObjectiveToDisplay(linearTransform);
                this.pointOfInterest = generalDirectPosition;
                this.objectivePOI = generalDirectPosition;
                this.objectiveCRS = coordinateReferenceSystem2;
                this.multidimToObjective = linearTransform2;
                this.augmentedObjectiveCRS = null;
                this.axisTypes = null;
                this.gridGeometry = gridGeometry;
                this.fireIfChanged(DISPLAY_BOUNDS_PROPERTY, generalEnvelope2, generalEnvelope);
                this.fireIfChanged(OBJECTIVE_CRS_PROPERTY, coordinateReferenceSystem3, coordinateReferenceSystem2);
                this.fireIfChanged(OBJECTIVE_TO_DISPLAY_PROPERTY, linearTransform3, linearTransform);
                this.fireIfChanged(POINT_OF_INTEREST_PROPERTY, generalDirectPosition2, generalDirectPosition);
            }
            catch (CannotEvaluateException | IncompleteGridGeometryException | TransformException | FactoryException throwable) {
                throw new RenderException(this.errors().getString((short)15, GRID_GEOMETRY_PROPERTY), throwable);
            }
        }
    }

    private void fireIfChanged(String string, Object object, Object object2) {
        if (!Objects.equals(object, object2)) {
            this.firePropertyChange(string, object, object2);
        }
    }

    public Optional<GeographicBoundingBox> getGeographicArea() throws RenderException {
        try {
            return this.operationContext.getGeographicArea(this);
        }
        catch (TransformException transformException) {
            throw new RenderException(this.errors().getString((short)5, GEOGRAPHIC_AREA_PROPERTY), transformException);
        }
    }

    public OptionalDouble getSpatialResolution() throws RenderException {
        try {
            return this.operationContext.getSpatialResolution(this);
        }
        catch (TransformException transformException) {
            throw new RenderException(this.errors().getString((short)5, SPATIAL_RESOLUTION_PROPERTY), transformException);
        }
    }

    private CoordinateOperation objectiveToGeographic(CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException {
        GeographicCRS geographicCRS = ReferencingUtilities.toNormalizedGeographicCRS(coordinateReferenceSystem, false, false);
        return geographicCRS != null ? this.coordinateOperationFactory.createOperation(coordinateReferenceSystem, (CoordinateReferenceSystem)geographicCRS) : null;
    }

    private MathTransform findTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, boolean bl) throws FactoryException, TransformException, RenderException {
        if (bl) {
            bl = Utilities.equalsIgnoreMetadata(coordinateReferenceSystem, this.displayBounds.getCoordinateReferenceSystem());
        }
        if (bl) {
            coordinateReferenceSystem = this.objectiveCRS;
        }
        this.operationContext.refresh(this);
        MathTransform mathTransform = this.coordinateOperationFactory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2, this.operationContext).getMathTransform();
        if (bl) {
            mathTransform = MathTransforms.concatenate(this.getObjectiveToDisplay().inverse(), mathTransform);
        }
        return mathTransform;
    }

    DirectPosition allocatePosition() {
        return new GeneralDirectPosition(this.objectiveCRS);
    }

    private Errors errors() {
        return Errors.getResources(this.locale);
    }
}

