/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.landsat;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.wkt.FirstKeywordPeek;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.landsat.LandsatStore;
import org.opengis.parameter.ParameterDescriptorGroup;

@StoreMetadata(formatName="Landsat", fileSuffixes={"txt"}, capabilities={Capability.READ})
public class LandsatStoreProvider
extends DataStoreProvider {
    static final String NAME = "Landsat";
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR = URIDataStore.Provider.descriptor("Landsat");

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    static Path getMetadataFile(Path path) {
        Path path2;
        if (path != null && Files.isRegularFile(path2 = path.resolve(Paths.get(path.getFileName().toString().concat("_MTL.txt"), new String[0])), new LinkOption[0])) {
            return path2;
        }
        return null;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        return new Peek().probeContent(storageConnector);
    }

    @Override
    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        return new LandsatStore(this, storageConnector);
    }

    private static final class Peek
    extends FirstKeywordPeek {
        private static final String KEYWORD = "GROUP=LANDSAT_METADATA_FILE";
        private static final String L1_KEYWORD = "GROUP=L1_METADATA_FILE";
        private static final int KEY = 0;
        private static final int SEPARATOR = 1;
        private static final int VALUE = 2;
        private int part = 0;

        Peek() {
            super(KEYWORD.length());
        }

        @Override
        protected Path getAuxiliaryPath(StorageConnector storageConnector) throws DataStoreException {
            return LandsatStoreProvider.getMetadataFile(storageConnector.getStorageAs(Path.class));
        }

        @Override
        protected int isKeywordChar(int n) {
            int n2 = super.isKeywordChar(n);
            if (n2 == 0) {
                if (n >= 48 && n <= 57 && this.part == 2) {
                    return 1;
                }
                switch (n) {
                    case 9: 
                    case 32: {
                        if (this.part >= 2) break;
                        return 2;
                    }
                    case 61: {
                        if (this.part != 0) break;
                        this.part = 1;
                        return 1;
                    }
                }
            } else if (this.part == 1) {
                this.part = 2;
            }
            return n2;
        }

        @Override
        protected boolean isPostKeyword(int n) {
            return n == 71 || n == 103 || n == 35;
        }

        @Override
        protected ProbeResult forKeyword(char[] cArray, int n) {
            String string = new String(cArray, 0, n);
            if (KEYWORD.equalsIgnoreCase(string) || L1_KEYWORD.equalsIgnoreCase(string)) {
                return ProbeResult.SUPPORTED;
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
    }
}

