/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.landsat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.sis.internal.storage.AbstractResource;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.landsat.Band;
import org.apache.sis.storage.landsat.BandGroupName;
import org.apache.sis.util.ArraysExt;
import org.opengis.util.GenericName;

final class BandGroup
extends AbstractResource
implements Aggregate {
    final BandGroupName group;
    GenericName identifier;
    private final Band[] components;

    private BandGroup(StoreListeners storeListeners, BandGroupName bandGroupName, Band[] bandArray, int n) {
        super(storeListeners);
        this.group = bandGroupName;
        int n2 = 0;
        Object[] objectArray = new Band[bandArray.length];
        for (int i = 0; i < n; ++i) {
            Band band = bandArray[i];
            if (band.band.group != bandGroupName) continue;
            objectArray[n2++] = band;
        }
        this.components = (Band[])ArraysExt.resize((Object[])objectArray, (int)n2);
    }

    static BandGroup[] group(StoreListeners storeListeners, Band[] bandArray, int n) {
        BandGroupName[] bandGroupNameArray = BandGroupName.values();
        Object[] objectArray = new BandGroup[bandGroupNameArray.length];
        int n2 = 0;
        for (BandGroupName bandGroupName : bandGroupNameArray) {
            BandGroup bandGroup = new BandGroup(storeListeners, bandGroupName, bandArray, n);
            if (bandGroup.components.length == 0) continue;
            objectArray[n2++] = bandGroup;
        }
        return (BandGroup[])ArraysExt.resize((Object[])objectArray, (int)n2);
    }

    @Override
    public Optional<GenericName> getIdentifier() {
        return Optional.of(this.identifier);
    }

    @Override
    protected void createMetadata(MetadataBuilder metadataBuilder) throws DataStoreException {
        metadataBuilder.addTitle((CharSequence)this.group.title);
        super.createMetadata(metadataBuilder);
    }

    public Collection<Resource> components() {
        return UnmodifiableArrayList.wrap((Object[])this.components);
    }

    static final List<Band> bands(BandGroup[] bandGroupArray) {
        ArrayList<Band> arrayList = new ArrayList<Band>();
        if (bandGroupArray != null) {
            for (BandGroup bandGroup : bandGroupArray) {
                arrayList.addAll(Arrays.asList(bandGroup.components));
            }
        }
        return arrayList;
    }
}

