/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.setup;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.sis.internal.setup.FXFinder;
import org.apache.sis.internal.setup.WizardPage;

final class Wizard
extends FileFilter
implements ActionListener,
PropertyChangeListener,
DropTargetListener {
    private static final int WIDTH = 700;
    private static final String BACK = "Back";
    private static final String NEXT = "Next";
    private static final String CANCEL = "Cancel";
    private static final String JAVAFX_HOME = "Open JavaFX home page";
    private static final String BROWSE = "Browse";
    private static final String SELECT = "Select";
    private final Color TITLE_COLOR = new Color(36, 113, 163);
    private final Color SELECTED_TITLE_COLOR = new Color(21, 67, 96);
    private static final String TITLE_BULLET = "\u2022 ";
    private static final String SELECTED_TITLE_BULLET = "\u2023 ";
    private final Border JAVAFX_PATH_BORDER = new LineBorder(Color.GRAY);
    private final Border JAVAFX_PATH_BORDER_DND = new LineBorder(new Color(40, 180, 99), 3);
    private final JFrame wizard;
    private final JPanel cardPanel;
    private final JButton nextButton;
    private final JButton backButton;
    private final JButton cancelButton;
    private JButton selectButton;
    private final JLabel[] titles;
    private WizardPage currentPage;
    private boolean acceptLocation;
    final FXFinder javafxFinder;
    private final JLabel javafxPath;
    private final JLabel javafxPathError;
    private JLabel finalMessage;
    private JLabel finalJavafxPath;
    final JProgressBar inflateProgress;

    private Wizard(final FXFinder fXFinder) {
        this.javafxFinder = fXFinder;
        this.wizard = new JFrame("Apache SIS setup");
        Container container = this.wizard.getContentPane();
        container.setLayout(new BorderLayout());
        WizardPage[] wizardPageArray = Box.createHorizontalBox();
        wizardPageArray.setBorder(new EmptyBorder(9, 12, 9, 15));
        this.backButton = this.createButton((Box)wizardPageArray, BACK);
        wizardPageArray.add(Box.createHorizontalStrut(10));
        this.nextButton = this.createButton((Box)wizardPageArray, NEXT);
        wizardPageArray.add(Box.createHorizontalStrut(30));
        this.cancelButton = this.createButton((Box)wizardPageArray, CANCEL);
        this.backButton.setEnabled(false);
        Serializable serializable = new JPanel(new BorderLayout());
        serializable.add(new JSeparator(), "North");
        serializable.add((Component)wizardPageArray, "East");
        container.add((Component)serializable, "South");
        wizardPageArray = WizardPage.values();
        this.titles = new JLabel[wizardPageArray.length];
        serializable = new EmptyBorder(3, 0, 3, 0);
        WizardPage[] wizardPageArray2 = Box.createVerticalBox();
        for (int i = 0; i < wizardPageArray.length; ++i) {
            String string = (i == 0 ? SELECTED_TITLE_BULLET : TITLE_BULLET) + wizardPageArray[i].title;
            JLabel object = new JLabel(string, 2);
            object.setForeground(i == 0 ? this.SELECTED_TITLE_COLOR : this.TITLE_COLOR);
            object.setBorder((Border)((Object)serializable));
            this.titles[i] = object;
            wizardPageArray2.add(this.titles[i]);
        }
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(169, 204, 227));
        jPanel.setBorder(new EmptyBorder(40, 15, 9, 24));
        jPanel.add((Component)wizardPageArray2);
        container.add((Component)jPanel, "West");
        serializable = new Font("Serif", 0, 14);
        this.javafxPath = new JLabel();
        this.javafxPath.setBorder(this.JAVAFX_PATH_BORDER);
        this.javafxPathError = new JLabel();
        this.javafxPathError.setForeground(Color.RED);
        this.javafxPathError.setFont((Font)serializable);
        this.inflateProgress = new JProgressBar();
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.setBorder(new EmptyBorder(30, 30, 9, 30));
        this.cardPanel.setBackground(Color.WHITE);
        for (WizardPage wizardPage : wizardPageArray) {
            this.cardPanel.add((Component)this.createPage(wizardPage, (Font)serializable), wizardPage.name());
        }
        this.currentPage = wizardPageArray[0];
        container.add((Component)this.cardPanel, "Center");
        this.wizard.setSize(700, 500);
        this.wizard.setResizable(false);
        this.wizard.setLocationRelativeTo(null);
        this.wizard.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                fXFinder.cancel();
            }
        });
    }

    private Box createPage(WizardPage wizardPage, Font font) {
        Box box = Box.createVerticalBox();
        JLabel jLabel = new JLabel(wizardPage.text, 2);
        jLabel.setFont(font);
        box.add(jLabel);
        box.add(Box.createVerticalStrut(30));
        switch (wizardPage) {
            case DOWNLOAD_JAVAFX: {
                JButton jButton = this.createButton(box, JAVAFX_HOME);
                jButton.setToolTipText("https://openjfx.io/");
                jButton.setEnabled(Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE));
                JLabel jLabel2 = new JLabel(WizardPage.downloadSteps());
                jLabel2.setFont(font.deriveFont(12.0f));
                box.add(jLabel2);
                break;
            }
            case JAVAFX_LOCATION: {
                this.javafxPath.setMinimumSize(new Dimension(100, 30));
                this.javafxPath.setMaximumSize(new Dimension(700, 30));
                box.add(this.javafxPath);
                box.add(Box.createVerticalStrut(12));
                this.createButton(box, BROWSE);
                box.add(Box.createVerticalStrut(24));
                box.add(this.javafxPathError);
                box.setDropTarget(new DropTarget(box, this));
                break;
            }
            case DECOMPRESS: {
                this.inflateProgress.setMinimumSize(new Dimension(100, 21));
                this.inflateProgress.setMaximumSize(new Dimension(700, 21));
                box.add(this.inflateProgress);
                break;
            }
            case COMPLETED: {
                this.finalMessage = jLabel;
                EmptyBorder emptyBorder = new EmptyBorder(0, 15, 9, 0);
                Font font2 = new Font("Monospaced", 1, 13);
                Font font3 = new Font("SansSerif", 0, 13);
                for (String[] stringArray : this.javafxFinder.getEnvironmentVariables()) {
                    JLabel jLabel3 = new JLabel(stringArray[0] + ":");
                    JLabel jLabel4 = new JLabel(stringArray[1]);
                    jLabel3.setForeground(Color.DARK_GRAY);
                    jLabel4.setForeground(Color.DARK_GRAY);
                    jLabel3.setFont(font2);
                    jLabel4.setFont(font3);
                    jLabel4.setBorder(emptyBorder);
                    jLabel3.setLabelFor(jLabel4);
                    box.add(jLabel3);
                    box.add(jLabel4);
                    if (!"PATH_TO_FX".equals(stringArray[0])) continue;
                    this.finalJavafxPath = jLabel4;
                }
                break;
            }
        }
        return box;
    }

    private JButton createButton(Box box, String string) {
        JButton jButton = new JButton(string);
        jButton.setActionCommand(string);
        jButton.addActionListener(this);
        box.add(jButton);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        switch (actionEvent.getActionCommand()) {
            case "Cancel": {
                this.javafxFinder.cancel();
                break;
            }
            case "Back": {
                this.nextOrPreviousPage(-1);
                break;
            }
            case "Next": {
                this.nextOrPreviousPage(1);
                break;
            }
            case "Open JavaFX home page": {
                this.openJavafxHomePage();
                break;
            }
            case "Browse": {
                this.showDirectoryChooser();
            }
        }
    }

    private void nextOrPreviousPage(int n) {
        int n2 = this.currentPage.ordinal();
        JLabel jLabel = this.titles[n2];
        jLabel.setForeground(this.TITLE_COLOR);
        jLabel.setText(TITLE_BULLET + this.currentPage.title);
        WizardPage[] wizardPageArray = WizardPage.values();
        if ((n2 += n) >= wizardPageArray.length) {
            this.wizard.dispose();
            System.exit(0);
            return;
        }
        this.currentPage = wizardPageArray[n2];
        jLabel = this.titles[n2];
        jLabel.setForeground(this.SELECTED_TITLE_COLOR);
        jLabel.setText(SELECTED_TITLE_BULLET + this.currentPage.title);
        this.backButton.setEnabled(n2 > 0);
        this.nextButton.setEnabled(true);
        switch (this.currentPage) {
            case JAVAFX_LOCATION: {
                this.nextButton.setEnabled(this.acceptLocation);
                break;
            }
            case DECOMPRESS: {
                this.backButton.setEnabled(false);
                this.nextButton.setEnabled(false);
                if (this.javafxFinder.decompress(this)) break;
                this.nextOrPreviousPage(n);
                return;
            }
            case COMPLETED: {
                this.backButton.setEnabled(false);
                this.nextButton.setText("Finish");
                try {
                    this.javafxFinder.commit();
                    this.cancelButton.setEnabled(false);
                    this.finalJavafxPath.setText(this.javafxFinder.getValidatedDirectory());
                    break;
                }
                catch (IOException iOException) {
                    this.nextButton.setEnabled(false);
                    this.finalMessage.setForeground(Color.RED);
                    this.finalMessage.setText(Wizard.getHtmlMessage("Apache SIS setup can not be completed.", iOException));
                }
            }
        }
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, this.currentPage.name());
    }

    final void decompressionFinished(File file, Exception exception) {
        boolean bl;
        if (exception != null) {
            bl = false;
            this.javafxPathError.setText(Wizard.getHtmlMessage("Can not decompress the file.", exception));
        } else {
            bl = this.setJavafxPath(file);
        }
        this.javafxFinder.useRelativePath = bl;
        this.nextOrPreviousPage(bl ? 1 : -1);
    }

    private static String getHtmlMessage(String string, Exception exception) {
        StringBuilder stringBuilder = new StringBuilder(100).append("<html>").append(string).append("<br><b>").append(exception.getClass().getSimpleName()).append("</b>");
        String string2 = exception.getLocalizedMessage();
        if (string2 != null) {
            string2 = string2.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
            stringBuilder.append(": ").append(string2);
        }
        return stringBuilder.append("</html>").toString();
    }

    private void openJavafxHomePage() {
        try {
            Desktop.getDesktop().browse(new URI("https://openjfx.io/"));
        }
        catch (IOException | RuntimeException | URISyntaxException exception) {
            JOptionPane.showMessageDialog(this.wizard, exception.toString(), "Error", 0);
        }
    }

    private void showDirectoryChooser() {
        JFileChooser jFileChooser = new JFileChooser(this.javafxFinder.getDirectory());
        jFileChooser.addChoosableFileFilter(this);
        jFileChooser.setFileFilter(this);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setDialogTitle("JavaFX installation directory");
        jFileChooser.setApproveButtonText(SELECT);
        this.selectButton = Wizard.findSelectButton(jFileChooser);
        jFileChooser.setApproveButtonText(null);
        if (this.selectButton != null) {
            this.selectButton.setEnabled(false);
            jFileChooser.addPropertyChangeListener(this);
        }
        if (jFileChooser.showOpenDialog(this.wizard) == 0) {
            this.setJavafxPath(jFileChooser.getSelectedFile());
        }
        this.selectButton = null;
    }

    private static JButton findSelectButton(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JButton jButton;
            Component component = container.getComponent(i);
            if (!(component instanceof JButton ? SELECT.equals((jButton = (JButton)component).getText()) : component instanceof Container && (jButton = Wizard.findSelectButton((Container)component)) != null)) continue;
            return jButton;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "ZIP files";
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return n >= 0 && string.regionMatches(true, n + 1, "zip", 0, 3);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        File file;
        switch (propertyChangeEvent.getPropertyName()) {
            default: {
                return;
            }
            case "SelectedFileChangedProperty": {
                file = (File)propertyChangeEvent.getNewValue();
                break;
            }
            case "directoryChanged": {
                file = ((JFileChooser)propertyChangeEvent.getSource()).getSelectedFile();
            }
        }
        boolean bl = false;
        if (file != null) {
            if (file.isFile()) {
                bl = true;
            } else if (file.isDirectory()) {
                bl = this.javafxFinder.setDirectory(file);
            }
        }
        this.selectButton.setEnabled(bl);
    }

    private boolean setJavafxPath(File file) {
        String string = null;
        boolean bl = this.javafxFinder.setDirectory(file);
        if (!bl) {
            if (file.isFile()) {
                try {
                    string = FXFinder.checkZip(file);
                    bl = string == null;
                }
                catch (IOException iOException) {
                    string = Wizard.getHtmlMessage("Can not open the file.", iOException);
                }
            } else {
                string = "<html>Not a recognized JavaFX directory or ZIP file.</html>";
            }
        }
        this.javafxPath.setText(file != null ? file.getPath() : null);
        this.javafxPath.setForeground(bl ? Color.DARK_GRAY : Color.RED);
        if (this.currentPage == WizardPage.JAVAFX_LOCATION) {
            this.nextButton.setEnabled(bl);
        }
        this.javafxPathError.setText(string);
        this.acceptLocation = bl;
        return bl;
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        for (DataFlavor dataFlavor : dropTargetDropEvent.getCurrentDataFlavors()) {
            if (!dataFlavor.isFlavorJavaFileListType()) continue;
            this.javafxPath.setBorder(this.JAVAFX_PATH_BORDER);
            dropTargetDropEvent.acceptDrop(0x40000000);
            try {
                File file;
                Iterator iterator = ((Iterable)dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.javaFileListFlavor)).iterator();
                while (iterator.hasNext() && !this.setJavafxPath(file = (File)iterator.next())) {
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {
                this.javafxPathError.setText(Wizard.getHtmlMessage("Can not open the file.", exception));
            }
            dropTargetDropEvent.dropComplete(true);
            return;
        }
        dropTargetDropEvent.rejectDrop();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        for (DataFlavor dataFlavor : dropTargetDragEvent.getCurrentDataFlavors()) {
            if (!dataFlavor.isFlavorJavaFileListType()) continue;
            this.javafxPath.setBorder(this.JAVAFX_PATH_BORDER_DND);
            break;
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.javafxPath.setBorder(this.JAVAFX_PATH_BORDER);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public static boolean show(FXFinder fXFinder) {
        String string = fXFinder.diagnostic();
        if (string != null) {
            JOptionPane.showMessageDialog(null, string, "Configuration error", 0);
            return false;
        }
        Wizard wizard = new Wizard(fXFinder);
        wizard.wizard.setVisible(true);
        return true;
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ReflectiveOperationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
    }
}

