/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.setup;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JProgressBar;
import org.apache.sis.internal.setup.Wizard;

final class Inflater
implements Runnable {
    private final Wizard wizard;
    private final File source;
    private File destination;
    private File subdir;
    private Exception failure;
    private volatile boolean cancelled;

    Inflater(Wizard wizard, File file) {
        this.wizard = wizard;
        this.source = file;
    }

    @Override
    public synchronized void run() {
        try {
            this.doInBackground();
        }
        catch (Exception exception) {
            this.failure = exception;
            Inflater.delete(this.destination);
        }
        EventQueue.invokeLater(this::done);
    }

    private void doInBackground() throws Exception {
        this.destination = this.wizard.javafxFinder.getDestinationDirectory();
        JProgressBar jProgressBar = this.wizard.inflateProgress;
        byte[] byArray = new byte[65536];
        try (ZipFile zipFile = new ZipFile(this.source);){
            int n = zipFile.size();
            EventQueue.invokeAndWait(() -> jProgressBar.setMaximum(n));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                File file = new File(this.destination, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (!file.isDirectory() && !file.mkdir()) {
                        throw new IOException("Directory can not be created: " + file);
                    }
                    if (this.subdir == null && zipEntry.getName().startsWith("javafx-sdk-")) {
                        this.subdir = file;
                    }
                } else {
                    try (InputStream inputStream = zipFile.getInputStream(zipEntry);
                         FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        int n3;
                        while ((n3 = inputStream.read(byArray)) >= 0) {
                            if (this.cancelled) {
                                return;
                            }
                            ((OutputStream)fileOutputStream).write(byArray, 0, n3);
                        }
                    }
                }
                int n4 = n2++;
                EventQueue.invokeLater(() -> jProgressBar.setValue(n4));
            }
        }
    }

    private void done() {
        if (!this.cancelled) {
            if (this.subdir == null) {
                this.subdir = this.destination;
            }
            this.wizard.decompressionFinished(this.subdir, this.failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cancel() {
        this.cancelled = true;
        Inflater inflater = this;
        synchronized (inflater) {
            Inflater.delete(this.destination);
        }
    }

    private static void delete(File file) {
        if (file != null) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    Inflater.delete(file2);
                }
            }
            file.delete();
        }
    }
}

