/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.setup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.sis.internal.setup.Inflater;
import org.apache.sis.internal.setup.Wizard;

public final class FXFinder {
    static final int JAVAFX_VERSION = 13;
    static final String JAVAFX_HOME = "https://openjfx.io/";
    static final String JAVAFX_DIRECTORY_PREFIX = "javafx-sdk-";
    private static final String JAVAFX_LIB_DIRECTORY = "lib";
    private static final String JAVAFX_SENTINEL_FILE = "javafx.controls.jar";
    static final String PATH_VARIABLE = "PATH_TO_FX";
    private static final String SIS_CONF_DIRECTORY = "conf";
    private static final String SIS_UNZIP_DIRECTORY = "opt";
    private static final String WINDOWS_BATCH_EXTENSION = ".bat";
    private static final int CANCEL_EXIT_CODE = 1;
    private static final int ERROR_EXIT_CODE = 2;
    private File specified;
    private File validated;
    private final Path setenv;
    private Inflater inflater;
    boolean useRelativePath;
    private final boolean isWindows;

    private FXFinder(String string) {
        this.setenv = Paths.get(string, new String[0]).normalize();
        this.isWindows = string.endsWith(WINDOWS_BATCH_EXTENSION);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            if (Wizard.show(new FXFinder(stringArray[0]))) {
                return;
            }
        } else {
            System.out.println("Required: path to setenv.sh");
        }
        System.exit(2);
    }

    final String diagnostic() {
        if (Files.isReadable(this.setenv) && Files.isWritable(this.setenv)) {
            return null;
        }
        return "Can not edit " + this.setenv;
    }

    final String[][] getEnvironmentVariables() {
        return new String[][]{this.getEnvironmentVariable("JAVA_HOME"), this.getEnvironmentVariable(PATH_VARIABLE), this.getEnvironmentVariable("SIS_DATA"), this.getEnvironmentVariable("SIS_OPTS")};
    }

    private String[] getEnvironmentVariable(String string) {
        String string2;
        try {
            string2 = System.getenv(string);
            if (string2 == null) {
                string2 = "(undefined)";
            } else if (string2.isEmpty()) {
                string2 = "(blank)";
            } else if (string.equals("SIS_DATA") && string2.equals("bin/../data")) {
                string2 = Paths.get(string2, new String[0]).toAbsolutePath().toString();
            }
        }
        catch (SecurityException securityException) {
            string2 = "(unreadable)";
        }
        return new String[]{string, string2};
    }

    static String getJavafxBundleName() {
        String string;
        try {
            string = System.getProperty("os.name");
        }
        catch (SecurityException securityException) {
            string = null;
        }
        if (string == null) {
            string = "<operating system>";
        }
        return "JavaFX " + string + " SDK";
    }

    final String getValidatedDirectory() {
        return this.validated != null ? this.validated.getPath() : null;
    }

    final File getDirectory() {
        return this.specified;
    }

    final boolean setDirectory(File file) {
        this.specified = file;
        this.validated = null;
        if (new File(file, JAVAFX_SENTINEL_FILE).exists()) {
            this.validated = file;
            return true;
        }
        File file2 = new File(file, JAVAFX_LIB_DIRECTORY);
        if (new File(file2, JAVAFX_SENTINEL_FILE).exists()) {
            this.validated = file2;
            return true;
        }
        return false;
    }

    static String checkZip(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.isDirectory()) continue;
                String string = zipEntry.getName();
                if (string.startsWith(JAVAFX_DIRECTORY_PREFIX)) {
                    int n;
                    int n2 = JAVAFX_DIRECTORY_PREFIX.length();
                    int n3 = string.indexOf(46, n2);
                    if (n3 < n2) {
                        n3 = string.length();
                    }
                    if ((n = Integer.parseInt(string.substring(n2, n3))) < 13) {
                        String string2 = "<html>Apache SIS requires JavaFX version 13 or later. The given file contains JavaFX version " + n + ".</html>";
                        return string2;
                    }
                    if (zipFile.getEntry(string + "lib/javafx.controls.jar") != null) {
                        String string3 = null;
                        return string3;
                    }
                }
                break;
            }
        }
        return "<html>Not a recognized ZIP file for JavaFX SDK.</html>";
    }

    final File getDestinationDirectory() throws IOException {
        File file = this.setenv.toAbsolutePath().toFile().getParentFile();
        if (file != null && SIS_CONF_DIRECTORY.equals(file.getName()) && (file = file.getParentFile()) != null) {
            File file2 = new File(file, SIS_UNZIP_DIRECTORY);
            if (file2.isDirectory() || file2.mkdir()) {
                return file2;
            }
            throw new IOException("Can not create directory: " + file2);
        }
        throw new FileNotFoundException("No parent directory to " + this.setenv + ".");
    }

    final boolean decompress(Wizard wizard) {
        if (this.validated == null) {
            this.inflater = new Inflater(wizard, this.specified);
            Thread thread = new Thread((Runnable)this.inflater, "Inflater");
            thread.start();
            return true;
        }
        return false;
    }

    final void cancel() {
        if (this.inflater != null) {
            this.inflater.cancel();
        }
        System.exit(1);
    }

    final void commit() throws IOException {
        this.inflater = null;
        Object object = PATH_VARIABLE;
        if (this.isWindows) {
            object = "SET " + (String)object;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        for (String string : Files.readAllLines(this.setenv)) {
            String object2 = string.trim();
            if (object2.startsWith((String)object)) {
                n = arrayList.size();
                continue;
            }
            arrayList.add(object2);
        }
        if (n < 0) {
            n = arrayList.size();
        }
        StringBuilder stringBuilder = new StringBuilder(100).append((String)object).append('=');
        if (this.useRelativePath) {
            File file = FXFinder.relativeToBase(this.validated);
            if (file != null) {
                stringBuilder.append(this.isWindows ? "%BASE_DIR%" : "$BASE_DIR").append(File.separatorChar).append(file);
            } else {
                this.useRelativePath = false;
            }
        }
        if (!this.useRelativePath) {
            stringBuilder.append(this.validated);
        }
        arrayList.add(n, stringBuilder.toString());
        Files.write(this.setenv, arrayList, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static File relativeToBase(File file) {
        if (file != null) {
            if (SIS_UNZIP_DIRECTORY.equals(file.getName())) {
                return new File(SIS_UNZIP_DIRECTORY);
            }
            File file2 = FXFinder.relativeToBase(file.getParentFile());
            if (file2 != null) {
                return new File(file2, file.getName());
            }
        }
        return null;
    }
}

