/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.control;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.gui.control.FormatApplicator;

final class FormatTableCell<S, T>
extends TableCell<S, T> {
    private final FormatApplicator<T> textConverter;
    private TextField editor;
    private final Trigger<S> insertTrigger;

    public FormatTableCell(FormatApplicator<T> formatApplicator, Trigger<S> trigger) {
        this.textConverter = formatApplicator;
        this.insertTrigger = trigger;
        this.setAlignment(Pos.CENTER_LEFT);
    }

    protected void updateItem(T t, boolean bl) {
        super.updateItem(t, bl);
        String string = null;
        TextField textField = null;
        if (!bl) {
            if (this.isEditing()) {
                textField = this.editor;
                if (textField != null) {
                    this.textConverter.format(textField, t);
                }
            } else if (t != null) {
                string = this.textConverter.toString(t);
            }
        }
        this.setText(string);
        this.setGraphic((Node)textField);
    }

    public void startEdit() {
        String string;
        super.startEdit();
        String string2 = string = this.insertTrigger != null ? this.insertTrigger.initialText : null;
        if (string == null) {
            string = this.getText();
        }
        if (this.editor != null) {
            this.editor.pseudoClassStateChanged(Styles.ERROR, false);
            this.editor.setText(string);
        } else {
            this.editor = new TextField(string);
            this.editor.setOnAction(actionEvent -> {
                actionEvent.consume();
                T t = this.textConverter.parse(this.editor);
                if (t != null) {
                    this.commitEdit(t);
                }
            });
            this.editor.setOnKeyReleased(keyEvent -> {
                if (keyEvent.getCode() == KeyCode.ESCAPE) {
                    keyEvent.consume();
                    this.cancelEdit();
                }
            });
        }
        this.setText(null);
        this.setGraphic((Node)this.editor);
        this.editor.requestFocus();
        if (this.insertTrigger.initialText == null) {
            this.editor.selectAll();
        } else {
            this.editor.deselect();
            this.editor.end();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setGraphic(null);
        this.setText(this.textConverter.toString(this.getItem()));
    }

    static final class Trigger<S>
    implements EventHandler<KeyEvent> {
        private final TableColumn<S, ?> column;
        private char minusSign;
        private char zeroDigit;
        String initialText;

        public Trigger(TableColumn<S, ?> tableColumn, Format format) {
            this.column = tableColumn;
            if (format instanceof DecimalFormat) {
                DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)format).getDecimalFormatSymbols();
                this.minusSign = decimalFormatSymbols.getMinusSign();
                this.zeroDigit = decimalFormatSymbols.getZeroDigit();
            }
        }

        public void registerTo(TableView<S> tableView) {
            tableView.addEventHandler(KeyEvent.KEY_TYPED, (EventHandler)this);
            tableView.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
                if (keyEvent.getCode() == KeyCode.F2) {
                    TablePosition tablePosition;
                    TableView tableView = this.column.getTableView();
                    if (tableView.getEditingCell() == null && (tablePosition = tableView.getFocusModel().getFocusedCell()) != null) {
                        tableView.edit(tablePosition.getRow(), this.column);
                    }
                    keyEvent.consume();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(KeyEvent keyEvent) {
            char c;
            String string;
            TableView tableView = this.column.getTableView();
            if (tableView.getEditingCell() == null && (string = keyEvent.getCharacter()).length() == 1 && ((c = string.charAt(0)) >= '0' && c <= '9' || c == this.minusSign || c == this.zeroDigit)) {
                int n = tableView.getItems().size() - 1;
                tableView.getSelectionModel().select(n);
                try {
                    this.initialText = string;
                    tableView.edit(n, this.column);
                }
                finally {
                    this.initialText = null;
                }
                keyEvent.consume();
            }
        }
    }
}

