/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.control;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.util.CharSequences;

final class FormatApplicator<T>
extends StringConverter<T>
implements EventHandler<ActionEvent>,
ChangeListener<Boolean> {
    private final Class<T> valueType;
    final Format format;
    InvalidationListener listener;

    public FormatApplicator(Class<T> clazz, Format format) {
        this.valueType = clazz;
        this.format = format;
    }

    public static FormatApplicator<Number> createNumberFormat() {
        FormatApplicator<Number> formatApplicator = new FormatApplicator<Number>(Number.class, NumberFormat.getInstance());
        if (formatApplicator.format instanceof DecimalFormat) {
            ((DecimalFormat)formatApplicator.format).setParseBigDecimal(true);
        }
        return formatApplicator;
    }

    public final void setListenersOn(TextField textField) {
        textField.focusedProperty().addListener((ChangeListener)this);
        textField.setOnAction((EventHandler)this);
    }

    private static boolean isNil(Object object) {
        return object == null || object instanceof Double && ((Double)object).isNaN();
    }

    public final String toString(T t) {
        return FormatApplicator.isNil(t) ? null : this.format.format(t);
    }

    public final void format(TextField textField, T t) {
        textField.setText(this.toString(t));
        FormatApplicator.setErrorFlag(textField, false);
    }

    public final T fromString(String string) {
        if (string == null || (string = string.trim()).isEmpty()) {
            return null;
        }
        try {
            return this.valueType.cast(this.format.parseObject(string));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException);
        }
    }

    public final T parse(TextField textField) {
        int n;
        int n2;
        String string = textField.getText();
        if (string != null && (n2 = CharSequences.skipLeadingWhitespaces(string, 0, n = CharSequences.skipTrailingWhitespaces(string, 0, string.length()))) < n) {
            ParsePosition parsePosition = new ParsePosition(n2);
            T t = this.valueType.cast(this.format.parseObject(string, parsePosition));
            int n3 = parsePosition.getIndex();
            if (n3 >= n && !FormatApplicator.isNil(t)) {
                FormatApplicator.setErrorFlag(textField, false);
                return t;
            }
            textField.positionCaret(t != null ? n3 : parsePosition.getErrorIndex());
        }
        if (string != null && !string.isEmpty()) {
            FormatApplicator.setErrorFlag(textField, true);
        }
        return null;
    }

    private void parseAndStore(TextField textField) {
        T t = this.parse(textField);
        textField.setUserData(t);
        if (this.listener != null) {
            this.listener.invalidated((Observable)textField.getProperties());
        }
    }

    public void handle(ActionEvent actionEvent) {
        this.parseAndStore((TextField)actionEvent.getSource());
    }

    public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
        TextField textField = (TextField)((ReadOnlyProperty)observableValue).getBean();
        if (bl2.booleanValue()) {
            FormatApplicator.setErrorFlag(textField, false);
        } else {
            this.parseAndStore(textField);
        }
    }

    private static void setErrorFlag(TextField textField, boolean bl) {
        textField.pseudoClassStateChanged(Styles.ERROR, bl);
    }
}

