/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;

public final class Styles
extends Static {
    public static final String STYLESHEET = "org/apache/sis/gui/pseudo-classes.css";
    public static final int SCROLLBAR_WIDTH = 20;
    public static final int CHECKBOX_WIDTH = 40;
    public static final double ROW_HEIGHT = 30.0;
    public static final Color NORMAL_TEXT = Color.BLACK;
    public static final Color SELECTED_TEXT = Color.WHITE;
    public static final Color LOADING_TEXT = Color.BLUE;
    public static final Color CODE_TEXT = Color.LIGHTSLATEGREY;
    public static final Color OUTDATED_TEXT = Color.GRAY;
    public static final Color ERROR_TEXT = Color.RED;
    public static final Color EXPANDED_ROW = Color.GAINSBORO;
    public static final Color GROUP_BORDER = Color.SILVER;
    public static final Color SELECTION_BACKGROUND = Color.LIGHTBLUE;
    public static final PseudoClass ERROR = PseudoClass.getPseudoClass((String)"error");
    public static final String ERROR_DETAILS_ICON = "\u2139\ufe0f";
    public static final String WARNING_ICON = "\u26a0\ufe0f";
    public static final Insets FORM_INSETS = new Insets(12.0);

    private Styles() {
    }

    public static Image loadIcon(Class<?> clazz, String string, String string2) {
        Exception exception;
        Image image;
        try (InputStream inputStream = clazz.getResourceAsStream(string2);){
            image = new Image(inputStream);
            exception = image.getException();
        }
        catch (IOException iOException) {
            image = null;
            exception = iOException;
        }
        if (exception != null) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.gui"), clazz, string, exception);
        }
        return image;
    }

    public static GridPane createControlGrid(int n, Label ... labelArray) {
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.NEVER);
        columnConstraints2.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints2});
        gridPane.setPadding(FORM_INSETS);
        gridPane.setVgap(9.0);
        gridPane.setHgap(9.0);
        for (Label label : labelArray) {
            if (label == null) continue;
            Node node = label.getLabelFor();
            GridPane.setConstraints((Node)label, (int)0, (int)n);
            GridPane.setConstraints((Node)node, (int)1, (int)n);
            gridPane.getChildren().addAll((Object[])new Node[]{label, node});
            label.setMinWidth(Double.NEGATIVE_INFINITY);
            ++n;
        }
        return gridPane;
    }

    public static void setAllRowToSameHeight(GridPane gridPane) {
        Object[] objectArray = new RowConstraints[gridPane.getRowCount()];
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setPercentHeight(100.0 / (double)objectArray.length);
        Arrays.fill(objectArray, rowConstraints);
        gridPane.getRowConstraints().setAll(objectArray);
    }
}

