/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import org.apache.sis.gui.DataViewer;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.FrequencySortedSet;

public final class RecentChoices {
    public static final int MAXIMUM_REFERENCE_SYSTEMS = 20;
    private static final Preferences NODE = Preferences.userNodeForPackage(DataViewer.class);
    private static final String OPEN = "Open";
    private static final String FILES = "RecentFiles";
    private static final String CRS = "ReferenceSystems";
    private static final FrequencySortedSet<String> CRS_THIS_RUN = new FrequencySortedSet(true);

    private RecentChoices() {
    }

    public static File getOpenDirectory() {
        String string = NODE.get(OPEN, null);
        if (string != null) {
            File file = new File(string);
            do {
                if (!file.isDirectory()) continue;
                return file;
            } while ((file = file.getParentFile()) != null);
        }
        return null;
    }

    public static void setOpenDirectory(List<File> list) {
        File file = RecentChoices.getCommonParent(list);
        NODE.put(OPEN, file != null ? file.getAbsolutePath() : null);
    }

    public static CharSequence[] getFiles() {
        return CharSequences.splitOnEOL(NODE.get(FILES, null));
    }

    public static void setFiles(String string) {
        NODE.put(FILES, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getReferenceSystems() {
        String[] stringArray;
        FrequencySortedSet<String> frequencySortedSet = CRS_THIS_RUN;
        synchronized (frequencySortedSet) {
            int n = CRS_THIS_RUN.size();
            if (n != 0) {
                stringArray = CRS_THIS_RUN.toArray(new String[n]);
            } else {
                String string = NODE.get(CRS, null);
                stringArray = (String[])CharSequences.split(string, ',');
                CRS_THIS_RUN.addAll(Arrays.asList(stringArray));
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useReferenceSystem(String string) {
        if (string != null) {
            String[] stringArray;
            FrequencySortedSet<String> frequencySortedSet = CRS_THIS_RUN;
            synchronized (frequencySortedSet) {
                if (!CRS_THIS_RUN.add(string.trim())) {
                    return;
                }
                stringArray = CRS_THIS_RUN.toArray(new String[CRS_THIS_RUN.size()]);
            }
            RecentChoices.saveReferenceSystems(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveReferenceSystems() {
        String[] stringArray;
        FrequencySortedSet<String> frequencySortedSet = CRS_THIS_RUN;
        synchronized (frequencySortedSet) {
            stringArray = CRS_THIS_RUN.toArray(new String[CRS_THIS_RUN.size()]);
        }
        RecentChoices.saveReferenceSystems(stringArray);
    }

    private static void saveReferenceSystems(String[] stringArray) {
        if (stringArray.length != 0) {
            if (stringArray.length > 20) {
                stringArray = Arrays.copyOf(stringArray, 20);
            }
            NODE.put(CRS, String.join((CharSequence)",", stringArray));
        }
    }

    private static File getCommonParent(List<File> list) {
        File file = null;
        for (File file2 : list) {
            File file3 = file2.getParentFile();
            if (file3 == null || file3.equals(file)) continue;
            if (file == null) {
                file = file3;
                continue;
            }
            String string = file3.getAbsolutePath();
            while (!string.startsWith(file.getAbsolutePath())) {
                if ((file = file.getParentFile()) != null) continue;
                return null;
            }
        }
        return file;
    }

    public static <T> void setInList(ComboBox<T> comboBox, T t) {
        ObservableList observableList = comboBox.getItems();
        int n = observableList.indexOf(t);
        if (n != 0) {
            if (n > 0) {
                observableList.remove(n);
            } else {
                int n2 = observableList.size();
                if (n2 >= 20) {
                    observableList.remove(n2 - 1);
                }
            }
            observableList.add(0, t);
        }
        comboBox.getSelectionModel().selectFirst();
    }
}

