/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.text.Font;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.ImageConverter;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.math.Statistics;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.Vocabulary;

public final class PropertyView
extends CompoundFormat<Object> {
    private Object value;
    private final ObjectProperty<Node> view;
    private TextArea textView;
    private ListView<String> listView;
    private ImageView imageView;
    private final Pane imageCanvas;
    private GridPane imagePane;
    private Label sampleValueRange;
    private Label meanValue;
    private Rectangle visibleImageBounds;
    private Task<?> runningTask;

    public PropertyView(Locale locale, ObjectProperty<Node> objectProperty, ObjectProperty<Background> objectProperty2) {
        super(locale, null);
        this.view = objectProperty;
        this.imageCanvas = new Pane();
        if (objectProperty2 != null) {
            this.imageCanvas.backgroundProperty().bind(objectProperty2);
        }
    }

    @Override
    public Class<? extends Object> getValueType() {
        return Object.class;
    }

    @Override
    public Object parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        throw new ParseException(null, 0);
    }

    @Override
    public void format(Object object, Appendable appendable) throws IOException {
        Format format = this.getFormat(object.getClass());
        if (format != null) {
            format.format(object, (StringBuffer)appendable, new FieldPosition(0));
        } else {
            appendable.append(object.toString());
        }
    }

    private String formatValue(Object object) {
        Format format = this.getFormat(object.getClass());
        if (format == null) {
            return object.toString();
        }
        if (object instanceof Number) {
            return Numerics.useScientificNotationIfNeeded(format, object, Format::format);
        }
        return format.format(object);
    }

    private static void format(Format format2, double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Numerics.useScientificNotationIfNeeded(format2, d, (format, object) -> {
            format.format(object, stringBuffer, fieldPosition);
            return null;
        });
    }

    public void set(Object object, Rectangle rectangle) {
        if (object != this.value || !Objects.equals(rectangle, this.visibleImageBounds)) {
            if (this.runningTask != null) {
                this.runningTask.cancel();
                this.runningTask = null;
            }
            this.visibleImageBounds = rectangle;
            Node node = object == null ? null : (object instanceof RenderedImage ? this.setImage((RenderedImage)object) : (object instanceof Throwable ? this.setText((Throwable)object) : (object instanceof Collection ? this.setList(((Collection)object).toArray()) : (object.getClass().isArray() ? this.setList(object) : this.setText(this.formatValue(object))))));
            this.view.set(node);
            this.value = object;
        }
    }

    private Node setText(String string) {
        TextArea textArea = this.textView;
        if (textArea == null) {
            textArea = new TextArea();
            textArea.setEditable(false);
            textArea.setFont(Font.font((String)"Monospaced"));
            this.textView = textArea;
        }
        textArea.setText(string);
        return textArea;
    }

    private Node setText(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return this.setText(stringWriter.toString());
    }

    private Node setList(Object object) {
        ListView listView = this.listView;
        if (listView == null) {
            this.listView = listView = new ListView();
        }
        Object[] objectArray = new String[Array.getLength(object)];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.formatValue(Array.get(object, i));
        }
        this.listView.getItems().setAll(objectArray);
        return listView;
    }

    private Node setImage(RenderedImage renderedImage) {
        Object object;
        ImageView imageView = this.imageView;
        if (imageView == null) {
            imageView = new ImageView();
            imageView.setPreserveRatio(true);
            this.imageCanvas.getChildren().setAll((Object[])new Node[]{imageView});
            GUIUtilities.setClipToBounds(this.imageCanvas);
            GridPane.setConstraints((Node)this.imageCanvas, (int)0, (int)0, (int)2, (int)1);
            GridPane.setHgrow((Node)this.imageCanvas, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)this.imageCanvas, (Priority)Priority.ALWAYS);
            object = Vocabulary.getResources(this.getLocale());
            Label label = new Label(((IndexedResourceBundle)object).getLabel((short)215));
            Label label2 = new Label(((IndexedResourceBundle)object).getLabel((short)129));
            this.sampleValueRange = new Label();
            label.setLabelFor((Node)this.sampleValueRange);
            this.meanValue = new Label();
            label2.setLabelFor((Node)this.meanValue);
            Insets insets = new Insets(9.0, 0.0, 0.0, 9.0);
            label.setPadding(insets);
            this.sampleValueRange.setPadding(insets);
            insets = new Insets(3.0, 0.0, 9.0, 9.0);
            label2.setPadding(insets);
            this.meanValue.setPadding(insets);
            this.imagePane = Styles.createControlGrid(1, label, label2);
            this.imagePane.getChildren().add((Object)this.imageCanvas);
            this.imagePane.setPadding(Insets.EMPTY);
            this.imagePane.setVgap(0.0);
            this.imagePane.setHgap(0.0);
            this.imageView = imageView;
        }
        object = new ImageConverter(renderedImage, this.visibleImageBounds, imageView);
        object.setOnSucceeded(arg_0 -> this.lambda$setImage$1((ImageConverter)((Object)object), arg_0));
        object.setOnFailed(workerStateEvent -> {
            this.taskCompleted(null);
            this.view.set((Object)this.setText(workerStateEvent.getSource().getException()));
        });
        this.runningTask = object;
        BackgroundThreads.execute((Runnable)object);
        return this.imagePane;
    }

    private void taskCompleted(Statistics[] statisticsArray) {
        this.runningTask = null;
        String string = null;
        String string2 = null;
        if (statisticsArray != null && statisticsArray.length != 0) {
            Statistics statistics = statisticsArray[0];
            FieldPosition fieldPosition = new FieldPosition(0);
            StringBuffer stringBuffer = new StringBuffer();
            Format format = this.getFormat(Number.class);
            PropertyView.format(format, statistics.minimum(), stringBuffer, fieldPosition);
            stringBuffer.append(" \u2026 ");
            PropertyView.format(format, statistics.maximum(), stringBuffer, fieldPosition);
            string = stringBuffer.toString();
            stringBuffer.setLength(0);
            PropertyView.format(format, statistics.mean(), stringBuffer, fieldPosition);
            stringBuffer.append(" \u00b1 ");
            PropertyView.format(format, statistics.standardDeviation(false), stringBuffer, fieldPosition);
            Vocabulary vocabulary = Vocabulary.getResources(this.getLocale());
            stringBuffer.append(" (").append(vocabulary.getString((short)185)).append(')');
            string2 = stringBuffer.toString();
        }
        this.sampleValueRange.setText(string);
        this.meanValue.setText(string2);
    }

    public void clear() {
        this.value = null;
        this.view.set(null);
        if (this.textView != null) {
            this.textView.setText(null);
        }
        if (this.imageView != null) {
            this.imageView.setImage(null);
        }
    }

    private /* synthetic */ void lambda$setImage$1(ImageConverter imageConverter, WorkerStateEvent workerStateEvent) {
        this.taskCompleted((Statistics[])imageConverter.getValue());
    }
}

