/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.web.WebView;
import javafx.stage.Window;
import org.apache.sis.gui.DataViewer;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.system.Fallback;
import org.apache.sis.setup.OptionalInstallations;

@Fallback
public final class OptionalDataDownloader
extends OptionalInstallations {
    public OptionalDataDownloader() {
        super("text/html");
    }

    @Override
    protected boolean askUserAgreement(String string, String string2) {
        if (!Platform.isFxApplicationThread()) {
            return BackgroundThreads.runAndWait(() -> this.askUserAgreement(string, string2));
        }
        Resources resources = Resources.forLocale(this.getLocale());
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, null, new ButtonType[]{ButtonType.NO, ButtonType.YES});
        alert.initOwner((Window)DataViewer.getCurrentStage());
        alert.setTitle(resources.getString((short)60, string));
        alert.setResizable(true);
        if (string2 == null) {
            alert.getDialogPane().setPrefWidth(600.0);
            alert.setHeaderText(resources.getString((short)58, string));
            alert.setContentText(resources.getString((short)59, string, this.getSpaceRequirement(string), this.destinationDirectory));
        } else {
            WebView webView = new WebView();
            webView.getEngine().loadContent(string2);
            DialogPane dialogPane = alert.getDialogPane();
            dialogPane.setContent((Node)webView);
            dialogPane.setPrefWidth(800.0);
            dialogPane.setPrefHeight(600.0);
            alert.setHeaderText(resources.getString((short)61));
        }
        return alert.showAndWait().orElse(ButtonType.NO) == ButtonType.YES;
    }
}

