/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.lang.ref.Reference;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;

public final class LogHandler
extends Handler
implements StoreListener<WarningEvent> {
    private static final int LIMIT = 1000;
    private static final LogHandler INSTANCE = new LogHandler();
    private final ObservableList<LogRecord> systemLogs = FXCollections.observableArrayList();
    private final WeakHashMap<Resource, ObservableList<LogRecord>> resourceLogs = new WeakHashMap();
    private final ConcurrentMap<Long, ObservableList<LogRecord>> inProgress = new ConcurrentHashMap<Long, ObservableList<LogRecord>>();

    private LogHandler() {
    }

    public static void register(boolean bl) {
        Logger logger = Logger.getLogger("");
        if (bl) {
            logger.addHandler(INSTANCE);
        } else {
            logger.removeHandler(INSTANCE);
            INSTANCE.close();
        }
    }

    public static void installListener(Resource resource) {
        if (resource != null) {
            resource.addListener(WarningEvent.class, (StoreListener)INSTANCE);
        }
    }

    public static Long loadingStart(Reference<Resource> reference) {
        return LogHandler.loadingStart(reference != null ? reference.get() : null);
    }

    public static Long loadingStart(Resource resource) {
        if (resource == null) {
            return null;
        }
        Long l = Thread.currentThread().getId();
        LogHandler.INSTANCE.inProgress.put(l, INSTANCE.getRecordsNonNull(resource));
        return l;
    }

    public static void loadingStop(Long l) {
        if (l != null) {
            LogHandler.INSTANCE.inProgress.remove(l);
        }
    }

    public static ObservableList<LogRecord> getSystemRecords() {
        return LogHandler.INSTANCE.systemLogs;
    }

    public static ObservableList<LogRecord> getRecords(Resource resource) {
        return resource != null ? INSTANCE.getRecordsNonNull(resource) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObservableList<LogRecord> getRecordsNonNull(Resource resource2) {
        WeakHashMap<Resource, ObservableList<LogRecord>> weakHashMap = this.resourceLogs;
        synchronized (weakHashMap) {
            return this.resourceLogs.computeIfAbsent(resource2, resource -> FXCollections.observableArrayList());
        }
    }

    public void eventOccured(WarningEvent warningEvent) {
        LogRecord logRecord = warningEvent.getDescription();
        if (this.isLoggable(logRecord)) {
            ObservableList<LogRecord> observableList = this.getRecordsNonNull(warningEvent.getSource());
            if (Platform.isFxApplicationThread()) {
                observableList.add((Object)logRecord);
            } else {
                Platform.runLater(() -> observableList.add((Object)logRecord));
            }
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            Long l = Thread.currentThread().getId();
            ObservableList observableList = (ObservableList)this.inProgress.get(l);
            if (Platform.isFxApplicationThread()) {
                this.add(logRecord, (ObservableList<LogRecord>)observableList);
            } else {
                Platform.runLater(() -> this.add(logRecord, (ObservableList<LogRecord>)observableList));
            }
        }
    }

    private void add(LogRecord logRecord, ObservableList<LogRecord> observableList) {
        if (this.systemLogs.size() >= 1000) {
            this.systemLogs.remove(0);
        }
        this.systemLogs.add((Object)logRecord);
        if (observableList != null) {
            observableList.add((Object)logRecord);
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        WeakHashMap<Resource, ObservableList<LogRecord>> weakHashMap = this.resourceLogs;
        synchronized (weakHashMap) {
            this.resourceLogs.clear();
        }
        this.inProgress.clear();
    }
}

