/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.util.Map;
import javafx.concurrent.Task;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.gui.PropertyView;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.logging.Logging;

final class ImageConverter
extends Task<Statistics[]> {
    private static final int MAX_SIZE = 600;
    private static final Map<NumberRange<?>, Color[]> MASK_TRANSPARENCY = JDK9.mapOf(NumberRange.create(0, true, 0, true), new Color[]{ColorModelFactory.TRANSPARENT}, NumberRange.create(1, true, 1, true), new Color[]{new Color(0x30FFFF00, true)});
    private final RenderedImage source;
    private Rectangle bounds;
    private int width;
    private int height;
    private final ImageView canvas;
    private int[] data;

    ImageConverter(RenderedImage renderedImage, Rectangle rectangle, ImageView imageView) {
        this.source = renderedImage;
        this.bounds = rectangle;
        this.canvas = imageView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statistics[] call() {
        if (this.bounds == null) {
            this.bounds = ImageUtilities.getBounds((RenderedImage)this.source);
        }
        this.width = Math.min(this.bounds.width, 600);
        this.height = Math.min(this.bounds.height, 600);
        double d = Math.max((double)this.width / (double)this.bounds.width, (double)this.height / (double)this.bounds.height);
        this.width = (int)Math.round(d * (double)this.bounds.width);
        this.height = (int)Math.round(d * (double)this.bounds.height);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        affineTransform.translate(-this.bounds.x, -this.bounds.y);
        ImageProcessor imageProcessor = new ImageProcessor();
        Statistics[] statisticsArray = imageProcessor.valueOfStatistics(this.source, (Shape)this.bounds);
        RenderedImage renderedImage = imageProcessor.stretchColorRamp(this.source, JDK9.mapOf("multStdDev", 3, "statistics", statisticsArray));
        RenderedImage renderedImage2 = this.getMask(imageProcessor);
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
            if (renderedImage2 != null) {
                graphics2D.drawRenderedImage(renderedImage2, affineTransform);
            }
        }
        finally {
            graphics2D.dispose();
        }
        this.data = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        return statisticsArray;
    }

    private RenderedImage getMask(ImageProcessor imageProcessor) {
        Object object = this.source.getProperty("org.apache.sis.Mask");
        if (object instanceof RenderedImage) {
            try {
                return imageProcessor.visualize((RenderedImage)object, MASK_TRANSPARENCY);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.application"), PropertyView.class, "setImage", illegalArgumentException);
            }
        }
        return null;
    }

    protected void succeeded() {
        WritableImage writableImage = (WritableImage)this.canvas.getImage();
        if (writableImage == null || writableImage.getWidth() != (double)this.width || writableImage.getHeight() != (double)this.height) {
            writableImage = new WritableImage(this.width, this.height);
        }
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        pixelWriter.setPixels(0, 0, this.width, this.height, (PixelFormat)PixelFormat.getIntArgbPreInstance(), this.data, 0, this.width);
        this.data = null;
        this.canvas.setImage((Image)writableImage);
        this.canvas.setFitWidth((double)this.bounds.width);
        this.canvas.setFitHeight((double)this.bounds.height);
    }

    protected void failed() {
        this.data = null;
    }

    protected void cancelled() {
        this.data = null;
    }
}

